/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class RemoteCalendar
implements Serializable {
    private String type;
    private String username;
    private String calendarId;
    private String remoteUrl;
    private String calendarName;
    private String description = "";
    private String syncPeriod = "";
    private String beforeDateSave = "";
    private String afterDateSave = "";
    private long beforeDate = 0L;
    private long afterDate = 0L;
    private String remoteUser = "";
    private String remotePassword = "";
    private Calendar lastUpdated;
    private String calendarColor;

    public String getCalendarColor() {
        return this.calendarColor;
    }

    public void setCalendarColor(String calendarColor) {
        this.calendarColor = calendarColor;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getCalendarName() {
        return this.calendarName;
    }

    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSyncPeriod() {
        return this.syncPeriod;
    }

    public void setSyncPeriod(String syncPeriod) {
        this.syncPeriod = syncPeriod;
    }

    public String getBeforeDateSave() {
        return this.beforeDateSave;
    }

    public void setBeforeDateSave(String beforeDateSave) {
        this.setBeforeDate(this.getTimeField(beforeDateSave, true));
        this.beforeDateSave = beforeDateSave;
    }

    public String getAfterDateSave() {
        return this.afterDateSave;
    }

    public void setAfterDateSave(String afterDateSave) {
        this.setAfterDate(this.getTimeField(afterDateSave, false));
        this.afterDateSave = afterDateSave;
    }

    public long getBeforeDate() {
        return this.beforeDate;
    }

    public void setBeforeDate(long beforeDate) {
        this.beforeDate = beforeDate;
    }

    public long getAfterDate() {
        return this.afterDate;
    }

    public void setAfterDate(long afterDate) {
        this.afterDate = afterDate;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public Calendar getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Calendar lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Calendar getBeforeTime() {
        return this.calculateTime(this.beforeDate, true);
    }

    public Calendar getAfterTime() {
        return this.calculateTime(this.afterDate, false);
    }

    private Calendar calculateTime(long time, boolean isBefore) {
        Calendar cal = Calendar.getInstance();
        if (time != 0L) {
            cal.setTimeInMillis(cal.getTimeInMillis() + time);
        } else {
            cal.add(1, isBefore ? -1 : 1);
        }
        return cal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getTimeField(String vls, boolean isBefore) {
        try {
            long l;
            int vl = Integer.parseInt(vls.substring(0, 1));
            String unit = vls.substring(1, 2);
            Calendar calendar = GregorianCalendar.getInstance();
            Calendar calendar2 = GregorianCalendar.getInstance();
            long l2 = unit.equals("d") ? (long)(vl * 86400000) : (l = unit.equals("w") ? (long)(vl * 86400000 * 7) : 0L);
            if (l != 0L) return isBefore ? -1L * l : l;
            if (unit.equals("m")) {
                calendar.set(calendar.get(1), calendar.get(2) + (isBefore ? -1 * vl : vl), calendar.get(5));
                return calendar.getTimeInMillis() - calendar2.getTimeInMillis();
            } else {
                if (!unit.equals("y")) return 0L;
                calendar.set(calendar.get(1) + (isBefore ? -1 * vl : vl), calendar.get(2), calendar.get(5));
            }
            return calendar.getTimeInMillis() - calendar2.getTimeInMillis();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

