/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.web.redirect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exoplatform.portal.config.model.DevicePropertyCondition;
import org.exoplatform.portal.config.model.PortalRedirect;
import org.exoplatform.portal.config.model.RedirectCondition;
import org.exoplatform.portal.config.model.UserAgentConditions;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.web.redirect.api.RedirectKey;
import org.gatein.web.redirect.api.RedirectType;

public class Redirector {
    protected static Logger log = LoggerFactory.getLogger(Redirector.class);

    public RedirectKey getRedirectSite(ArrayList<PortalRedirect> portalRedirects, String userAgentString, Map<String, String> deviceProperties) {
        if (userAgentString == null) {
            userAgentString = "null";
        }
        boolean needsBrowserDetection = false;
        if (portalRedirects != null && !portalRedirects.isEmpty()) {
            for (PortalRedirect redirect : portalRedirects) {
                if (!redirect.isEnabled()) continue;
                RedirectType redirectCondition = this.checkConditions(userAgentString, deviceProperties, redirect.getConditions());
                if (redirectCondition == RedirectType.REDIRECT) {
                    log.debug((Object)("Found a match with UAS " + userAgentString + " and DeviceProperties " + deviceProperties + ". Setting redirect to : " + redirect.getRedirectSite()));
                    return RedirectKey.redirect(redirect.getRedirectSite());
                }
                if (redirectCondition != RedirectType.NEEDDEVICEINFO) continue;
                needsBrowserDetection = true;
            }
            if (!needsBrowserDetection) {
                log.debug((Object)"Could not find a match with the specified uas and device properties. Returning NO_REDIRECT_DETECTED");
                return RedirectKey.noRedirect();
            }
            log.debug((Object)"Found a match with the specified uas but it requires device properties. Returning NO_REDIRECT_DETECTED");
            return RedirectKey.needDeviceInfo();
        }
        log.debug((Object)"No UserAgentString specified and no device properties. Returning NO_REDIRECT_DETECTED");
        return RedirectKey.noRedirect();
    }

    protected RedirectType checkConditions(String userAgentString, Map<String, String> deviceProperties, List<RedirectCondition> conditions) {
        log.debug((Object)("Checking conditions for redirect with " + userAgentString + " and device properties " + deviceProperties));
        if (conditions != null) {
            for (RedirectCondition condition : conditions) {
                boolean userAgentStringMatch = this.checkUserAgentStrings(userAgentString, condition.getUserAgentConditions());
                log.debug((Object)("UserAgentStringMatch : " + userAgentStringMatch));
                if (!userAgentStringMatch) continue;
                if (condition.getDeviceProperties() == null || condition.getDeviceProperties().isEmpty()) {
                    log.debug((Object)"UserAgentStringMatch and no device detection has been specified. Using Redirect");
                    return RedirectType.REDIRECT;
                }
                if (deviceProperties == null) {
                    log.debug((Object)"Conditional device properties exists, but no deviceProperties available. Using Browser Detection");
                    return RedirectType.NEEDDEVICEINFO;
                }
                boolean devicePropertiesMatch = this.checkDeviceProperties(deviceProperties, condition.getDeviceProperties());
                if (devicePropertiesMatch) {
                    log.debug((Object)"UserAgentStringMatch and device properties match. Using Redirect");
                    return RedirectType.REDIRECT;
                }
                return RedirectType.NOREDIRECT;
            }
        }
        return RedirectType.NOREDIRECT;
    }

    protected boolean checkDeviceProperties(Map<String, String> deviceProperties, List<DevicePropertyCondition> conditions) {
        if (conditions != null && !conditions.isEmpty()) {
            if (deviceProperties == null) {
                return false;
            }
            for (DevicePropertyCondition deviceProperty : conditions) {
                if (deviceProperties.containsKey(deviceProperty.getPropertyName())) {
                    if (this.checkProperty(deviceProperties.get(deviceProperty.getPropertyName()), deviceProperty)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    protected boolean checkProperty(String propertyValue, DevicePropertyCondition deviceProperty) {
        Float propertyValueFloat;
        if (deviceProperty.getGreaterThan() != null) {
            try {
                propertyValueFloat = Float.valueOf(Float.parseFloat(propertyValue));
                if (propertyValueFloat.floatValue() <= deviceProperty.getGreaterThan().floatValue()) {
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)("Encountered a NumberFormatException trying to parse a property value (" + propertyValue + ") which should be a float."));
                return false;
            }
        }
        if (deviceProperty.getLessThan() != null) {
            try {
                propertyValueFloat = Float.valueOf(Float.parseFloat(propertyValue));
                if (propertyValueFloat.floatValue() >= deviceProperty.getLessThan().floatValue()) {
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)("Encountered a NumberFormatException trying to parse a property value (" + propertyValue + ") which should be a float."));
                return false;
            }
        }
        if (deviceProperty.getEquals() != null && !propertyValue.equals(deviceProperty.getEquals())) {
            return false;
        }
        if (deviceProperty.getMatches() != null) {
            try {
                Matcher matcher;
                Pattern pattern = Pattern.compile(deviceProperty.getMatches());
                if (propertyValue == null) {
                    propertyValue = "";
                }
                if (!(matcher = pattern.matcher(propertyValue)).find()) {
                    return false;
                }
            }
            catch (PatternSyntaxException pse) {
                log.debug((Object)("Encountered a PatternSyntaxException trying to compile a device property pattern (" + deviceProperty.getMatches() + ") which should be a valid string for a pattern."));
                return false;
            }
        }
        return true;
    }

    protected boolean checkUserAgentStrings(String userAgentString, UserAgentConditions condition) {
        if (condition.getDoesNotContain() != null && !condition.getDoesNotContain().isEmpty() && this.userAgentContains(userAgentString, condition.getDoesNotContain())) {
            return false;
        }
        if (condition.getContains() != null && !condition.getContains().isEmpty()) {
            return this.userAgentContains(userAgentString, condition.getContains());
        }
        return false;
    }

    protected boolean userAgentContains(String userAgentString, List<String> contains) {
        if (userAgentString != null) {
            for (String contain : contains) {
                Pattern pattern = Pattern.compile(contain);
                Matcher matcher = pattern.matcher(userAgentString);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }
}

