/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.proxy;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ProxyFilterService {
    private static final Logger log = LoggerFactory.getLogger(ProxyFilterService.class);
    private final List<Pattern> whiteList;
    private final List<Pattern> blackList;

    public ProxyFilterService(InitParams params) {
        this.whiteList = this.createList(params.getValuesParam("white-list"));
        this.blackList = this.createList(params.getValuesParam("black-list"));
        log.debug((Object)("Proxy filter service white list " + this.whiteList));
        log.debug((Object)("Proxy filter service black list " + this.blackList));
    }

    private List<Pattern> createList(ValuesParam values) {
        if (values != null) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (Object value : values.getValues()) {
                String s = ((String)value).trim();
                StringBuilder sb = new StringBuilder("^");
                block5: for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    switch (c) {
                        case '*': {
                            sb.append(".*");
                            continue block5;
                        }
                        case '$': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case '.': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case '^': 
                        case '|': {
                            sb.append("\\");
                            sb.append(c);
                            continue block5;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                sb.append("$");
                Pattern pattern = Pattern.compile(sb.toString());
                patterns.add(pattern);
            }
            return Collections.unmodifiableList(patterns);
        }
        return Collections.emptyList();
    }

    public boolean accept(HttpServletRequest request, PortalContainer container, URI remoteURI) {
        Pattern pattern;
        int i;
        String remoteServerName;
        boolean trace = log.isTraceEnabled();
        String remoteHost = remoteURI.getHost();
        if (remoteHost.equals(remoteServerName = request.getServerName())) {
            if (trace) {
                log.trace((Object)("Same host matching for URI " + remoteURI));
            }
            return true;
        }
        for (i = 0; i < this.blackList.size(); ++i) {
            pattern = this.blackList.get(i);
            boolean rejected = pattern.matcher(remoteHost).matches();
            if (trace) {
                log.trace((Object)("Black list " + pattern + (rejected ? " matched URI " : " did not match URI") + remoteURI));
            }
            if (!rejected) continue;
            log.info((Object)("URL for the gadget is blacklisted (pattern: " + pattern + "). Access to its contents has been blocked. URL: " + remoteURI));
            return false;
        }
        for (i = 0; i < this.whiteList.size(); ++i) {
            pattern = this.whiteList.get(i);
            boolean accepted = pattern.matcher(remoteHost).matches();
            if (trace) {
                log.trace((Object)("White list " + pattern + (accepted ? " matched URI " : " did not match URI") + remoteURI));
            }
            if (!accepted) continue;
            return true;
        }
        log.info((Object)("URL for the gadget is not white-listed. Access to its contents has been blocked. URL: " + remoteURI));
        return false;
    }
}

