/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.mop.SiteType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity(name="GateInSite")
@ExoEntity
@Table(name="PORTAL_SITES")
@NamedQueries(value={@NamedQuery(name="SiteEntity.findByKey", query="SELECT s FROM GateInSite s WHERE s.siteType = :siteType AND s.name = :name"), @NamedQuery(name="SiteEntity.findByType", query="SELECT s FROM GateInSite s WHERE s.siteType = :siteType"), @NamedQuery(name="SiteEntity.findSiteKey", query="SELECT s.name FROM GateInSite s WHERE s.siteType = :siteType")})
public class SiteEntity
extends ComponentEntity {
    private static final long serialVersionUID = 3036823700771832314L;
    @Id
    @SequenceGenerator(name="SEQ_SITE_ID_GENERATOR", sequenceName="SEQ_SITE_ID_GENERATOR")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SITE_ID_GENERATOR")
    @Column(name="ID")
    protected Long id;
    @Column(name="TYPE")
    private SiteType siteType;
    @Column(name="NAME", length=200)
    private String name;
    @Column(name="LOCALE", length=20)
    private String locale;
    @Column(name="SKIN", length=200)
    private String skin;
    @Column(name="LABEL", length=200)
    private String label;
    @Column(name="DESCRIPTION", length=2000)
    private String description;
    @Column(name="PROPERTIES", length=2000)
    private String properties = SiteEntity.getJSONString(new JSONObject());
    @Column(name="SITE_BODY", length=5000)
    private String siteBody = SiteEntity.getJSONString(new JSONArray());
    @Transient
    private List<ComponentEntity> children = new LinkedList<ComponentEntity>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSiteBody() {
        return this.siteBody;
    }

    public void setSiteBody(String siteBody) {
        this.siteBody = siteBody;
    }

    public SiteType getSiteType() {
        return this.siteType;
    }

    public void setSiteType(SiteType siteType) {
        this.siteType = siteType;
    }

    public List<ComponentEntity> getChildren() {
        return this.children;
    }

    public void setChildren(List<ComponentEntity> children) {
        this.children = children;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject obj = super.toJSON();
        JSONArray jChildren = new JSONArray();
        for (ComponentEntity child : this.getChildren()) {
            jChildren.add((Object)child.toJSON());
        }
        obj.put((Object)"children", (Object)jChildren);
        return obj;
    }

    @Override
    public ComponentEntity.TYPE getType() {
        return ComponentEntity.TYPE.SITE;
    }
}

