/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.lang.reflect.AnnotatedElement;
import juzu.impl.common.AbstractAnnotatedElement;

public abstract class ControlParameter {
    protected final String name;
    private final Class<?> type;
    private final AnnotatedElement annotations;

    public ControlParameter(String name, Class<?> type) throws NullPointerException {
        this(name, AbstractAnnotatedElement.EMPTY, type);
    }

    public ControlParameter(String name, AnnotatedElement annotations, Class<?> type) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null parameter name accepted");
        }
        this.name = name;
        this.type = type;
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public AnnotatedElement getAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ControlParameter) {
            ControlParameter that = (ControlParameter)obj;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + "]";
    }
}

