/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.header.QualityValue;
import org.exoplatform.services.rest.impl.header.AcceptLanguage;
import org.exoplatform.services.rest.impl.header.AcceptMediaType;
import org.exoplatform.services.rest.impl.header.AcceptToken;
import org.exoplatform.services.rest.impl.header.HeaderParameterParser;
import org.exoplatform.services.rest.impl.header.ListHeaderProducer;

public final class HeaderHelper {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.HeaderHelper");
    private static final Pattern WHITESPACE_QOUTE_PATTERN = Pattern.compile("[\\s\"]");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final String SEPARTORS = "()<>@,;:\"\\/[]?={}";
    private static final List<AcceptMediaType> ACCEPT_ALL_MEDIA_TYPE = Collections.singletonList(AcceptMediaType.DEFAULT);
    private static final List<AcceptLanguage> ACCEPT_ALL_LANGUAGE = Collections.singletonList(AcceptLanguage.DEFAULT);
    private static final List<AcceptToken> ACCEPT_ALL_TOKENS = Collections.singletonList(new AcceptToken("*"));
    public static final Comparator<QualityValue> QUALITY_VALUE_COMPARATOR = new Comparator<QualityValue>(){

        @Override
        public int compare(QualityValue o1, QualityValue o2) {
            float q2;
            float q1 = o1.getQvalue();
            if (q1 < (q2 = o2.getQvalue())) {
                return 1;
            }
            if (q1 > q2) {
                return -1;
            }
            return 0;
        }
    };
    private static final ListHeaderProducer<AcceptMediaType> LIST_MEDIA_TYPE_PRODUCER = new ListHeaderProducer<AcceptMediaType>(){

        @Override
        protected AcceptMediaType create(String part) {
            return AcceptMediaType.valueOf(part);
        }
    };
    private static final ListHeaderProducer<AcceptLanguage> LIST_LANGUAGE_PRODUCER = new ListHeaderProducer<AcceptLanguage>(){

        @Override
        protected AcceptLanguage create(String part) {
            return AcceptLanguage.valueOf(part);
        }
    };
    private static final ListHeaderProducer<AcceptToken> LIST_TOKEN_PRODUCER = new ListHeaderProducer<AcceptToken>(){

        @Override
        protected AcceptToken create(String part) {
            try {
                int col = part.indexOf(59);
                String token = col > 0 ? part.substring(0, col).trim() : part.trim();
                int i = -1;
                i = HeaderHelper.isToken(token);
                if (i != -1) {
                    throw new IllegalArgumentException("Not valid character at index " + i + " in " + token);
                }
                if (col < 0) {
                    return new AcceptToken(token);
                }
                Map<String, String> param = new HeaderParameterParser().parse(part);
                if (param.containsKey("q")) {
                    return new AcceptToken(token, HeaderHelper.parseQualityValue(param.get("q")));
                }
                return new AcceptToken(token);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
    };
    private static final String RFC_1123_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String RFC_1036_DATE_FORMAT = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final String ANSI_C_DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static ThreadLocal<List<SimpleDateFormat>> dateFormats = new ThreadLocal<List<SimpleDateFormat>>(){

        @Override
        protected List<SimpleDateFormat> initialValue() {
            ArrayList<SimpleDateFormat> l = new ArrayList<SimpleDateFormat>(3);
            l.add(new SimpleDateFormat(HeaderHelper.RFC_1123_DATE_FORMAT, Locale.US));
            l.add(new SimpleDateFormat(HeaderHelper.RFC_1036_DATE_FORMAT, Locale.US));
            l.add(new SimpleDateFormat(HeaderHelper.ANSI_C_DATE_FORMAT, Locale.US));
            TimeZone tz = Tools.getTimeZone((String)"GMT");
            ((SimpleDateFormat)l.get(0)).setTimeZone(tz);
            ((SimpleDateFormat)l.get(1)).setTimeZone(tz);
            ((SimpleDateFormat)l.get(2)).setTimeZone(tz);
            return Collections.unmodifiableList(l);
        }
    };

    private HeaderHelper() {
    }

    public static List<AcceptMediaType> createAcceptedMediaTypeList(String header) {
        if (header == null || header.length() == 0) {
            return ACCEPT_ALL_MEDIA_TYPE;
        }
        return LIST_MEDIA_TYPE_PRODUCER.createQualitySortedList(header);
    }

    public static List<AcceptLanguage> createAcceptedLanguageList(String header) {
        if (header == null || header.length() == 0) {
            return ACCEPT_ALL_LANGUAGE;
        }
        return LIST_LANGUAGE_PRODUCER.createQualitySortedList(header);
    }

    public static List<AcceptToken> createAcceptedCharsetList(String header) {
        if (header == null || header.length() == 0) {
            return ACCEPT_ALL_TOKENS;
        }
        return LIST_TOKEN_PRODUCER.createQualitySortedList(header);
    }

    public static List<AcceptToken> createAcceptedEncodingList(String header) {
        if (header == null || header.length() == 0) {
            return ACCEPT_ALL_TOKENS;
        }
        return LIST_TOKEN_PRODUCER.createQualitySortedList(header);
    }

    public static List<Cookie> parseCookies(String cookie) {
        int n = 0;
        int p = 0;
        TempCookie temp = null;
        int version = 0;
        ArrayList<Cookie> l = new ArrayList<Cookie>();
        while (p < cookie.length()) {
            n = HeaderHelper.findCookieParameterSeparator(cookie, p);
            String pair = cookie.substring(p, n);
            String name = "";
            String value = "";
            int eq = pair.indexOf(61);
            if (eq != -1) {
                name = pair.substring(0, eq).trim();
                value = pair.substring(eq + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
            } else {
                name = pair.trim();
            }
            if (name.indexOf(36) == -1) {
                if (temp != null) {
                    l.add(new Cookie(temp.name, temp.value, temp.path, temp.domain, temp.version));
                }
                temp = new TempCookie(name, value);
                temp.version = version;
            } else if (name.equalsIgnoreCase("$Version")) {
                version = Integer.valueOf(value);
            } else if (name.equalsIgnoreCase("$Path") && temp != null) {
                temp.path = value;
            } else if (name.equalsIgnoreCase("$Domain") && temp != null) {
                temp.domain = value;
            }
            p = n + 1;
        }
        if (temp != null) {
            l.add(new Cookie(temp.name, temp.value, temp.path, temp.domain, temp.version));
        }
        return l;
    }

    public static List<SimpleDateFormat> getDateFormats() {
        return dateFormats.get();
    }

    public static Date parseDateHeader(String header) {
        block3: {
            try {
                Iterator<SimpleDateFormat> iterator = HeaderHelper.getDateFormats().iterator();
                if (iterator.hasNext()) {
                    SimpleDateFormat format = iterator.next();
                    return format.parse(header);
                }
            }
            catch (ParseException e) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        throw new IllegalArgumentException("Not found appropriated date format for " + header);
    }

    public static long getContentLengthLong(MultivaluedMap<String, String> httpHeaders) {
        String t = (String)httpHeaders.getFirst((Object)"Content-Length");
        return t != null ? Long.parseLong(t) : 0L;
    }

    public static String getHeaderAsString(Object o) {
        RuntimeDelegate.HeaderDelegate hd = RuntimeDelegate.getInstance().createHeaderDelegate(o.getClass());
        return hd != null ? hd.toString(o) : o.toString();
    }

    public static String convertToString(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String t : collection) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(t);
        }
        return sb.toString();
    }

    static void appendWithQuote(StringBuffer sb, String s) {
        if (s == null) {
            return;
        }
        Matcher m = WHITESPACE_QOUTE_PATTERN.matcher(s);
        if (m.find()) {
            sb.append('\"');
            HeaderHelper.appendEscapeQuote(sb, s);
            sb.append('\"');
            return;
        }
        sb.append(s);
    }

    static void appendEscapeQuote(StringBuffer sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    static String removeWhitespaces(String s) {
        Matcher m = WHITESPACE_PATTERN.matcher(s);
        if (m.find()) {
            return m.replaceAll("");
        }
        return s;
    }

    static String addQuotesIfHasWhitespace(String s) {
        Matcher macther = WHITESPACE_PATTERN.matcher(s);
        if (macther.find()) {
            return '\"' + s + '\"';
        }
        return s;
    }

    static float parseQualityValue(String qstring) {
        if (qstring.length() > 5) {
            throw new IllegalArgumentException("Quality value string has more then 5 characters");
        }
        float q = Float.valueOf(qstring).floatValue();
        if (q > 1.0f) {
            throw new IllegalArgumentException("Quality value can't be greater then 1.0");
        }
        return q;
    }

    static int isToken(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c < '\u007f' && SEPARTORS.indexOf(c) == -1) continue;
            return i;
        }
        return -1;
    }

    private static int findCookieParameterSeparator(String cookie, int start) {
        int comma = cookie.indexOf(44, start);
        int semicolon = cookie.indexOf(59, start);
        int p = comma > 0 && semicolon > 0 ? (comma < semicolon ? comma : semicolon) : (comma < 0 && semicolon > 0 ? semicolon : (comma > 0 && semicolon < 0 ? comma : cookie.length()));
        return p;
    }

    static String filterEscape(String token) {
        StringBuffer sb = new StringBuffer();
        int strlen = token.length();
        for (int i = 0; i < strlen; ++i) {
            char c = token.charAt(i);
            if (c == '\\' && i < strlen - 1 && token.charAt(i + 1) == '\"') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static class TempCookie {
        String name;
        String value;
        int version;
        String path;
        String domain;
        String comment;
        int maxAge;
        boolean security;

        public TempCookie(String name, String value) {
            this.name = name;
            this.value = value;
            this.version = 1;
            this.domain = null;
            this.path = null;
            this.comment = null;
            this.maxAge = -1;
            this.security = false;
        }
    }
}

