/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.software.register.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.software.register.model.SoftwareRegistration;
import org.exoplatform.software.register.service.SoftwareRegistrationService;

public class SoftwareRegisterAuthViewServlet
extends HttpServlet {
    private static final Log LOG = ExoLogger.getLogger(SoftwareRegisterAuthViewServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String SR_JSP_RESOURCE = "/WEB-INF/jsp/software-registration/softwareregister.jsp";
    private static final String SR_JSP_RESOURCE_SUCCESS = "/WEB-INF/jsp/software-registration/softwareregister-success.jsp";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SettingService settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        SoftwareRegistrationService softwareRegistrationService = (SoftwareRegistrationService)PortalContainer.getInstance().getComponentInstanceOfType(SoftwareRegistrationService.class);
        if (softwareRegistrationService.isSoftwareRegistered()) {
            response.sendRedirect("/");
            return;
        }
        String code = request.getParameter("code");
        if (StringUtils.isEmpty((String)code)) {
            try {
                this.getServletContext().getRequestDispatcher(SR_JSP_RESOURCE).forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception se) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)se);
                }
                response.sendRedirect("/");
            }
            return;
        }
        SoftwareRegistration softwareRegistration = softwareRegistrationService.registrationPLF(code, SoftwareRegisterAuthViewServlet.getRegistrationURL(request));
        if (!softwareRegistration.isPushInfo()) {
            if (softwareRegistration.isNotReachable()) {
                request.getSession().setAttribute("notReachable", (Object)"true");
                this.getServletContext().getRequestDispatcher(SR_JSP_RESOURCE).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.getServletContext().setAttribute("status", (Object)"failed");
            request.getSession().setAttribute("notReachable", (Object)"true");
            response.sendRedirect("/");
            return;
        }
        settingService.set(Context.GLOBAL, Scope.GLOBAL, "softwareRegistrationNode", SettingValue.create((String)"Software registered:true"));
        softwareRegistrationService.checkSoftwareRegistration();
        this.getServletContext().setAttribute("status", (Object)"success");
        this.getServletContext().getRequestDispatcher(SR_JSP_RESOURCE_SUCCESS).forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String registrationULR = SoftwareRegisterAuthViewServlet.getRegistrationURL(request);
        request.setAttribute("registrationURL", (Object)registrationULR);
        request.getSession().setAttribute("registrationURL", (Object)registrationULR);
        this.doPost(request, response);
    }

    public static String getRegistrationURL(HttpServletRequest request) {
        SoftwareRegistrationService registrationService = (SoftwareRegistrationService)CommonsUtils.getService(SoftwareRegistrationService.class);
        String returnUrl = "http://{0}:{1}/registration/software-register-auth";
        returnUrl = returnUrl.replace("{0}", request.getServerName());
        returnUrl = returnUrl.replace("{1}", String.valueOf(request.getServerPort()));
        StringBuffer _registrationURL = new StringBuffer();
        _registrationURL.append(registrationService.getSoftwareRegistrationHost());
        _registrationURL.append("/portal/authorize");
        _registrationURL.append("?").append("client_id=x6iCo6YWmw");
        _registrationURL.append("&").append("response_type=code");
        _registrationURL.append("&redirect_uri=").append(returnUrl);
        return _registrationURL.toString();
    }
}

