/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.resource;

import java.io.File;
import java.lang.ref.WeakReference;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.commons.file.resource.WorkerThread;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileCleaner
extends WorkerThread {
    protected static final long DEFAULT_TIMEOUT = 30000L;
    protected static final Log LOG = ExoLogger.getLogger((String)FileCleaner.class.getName());
    protected static final ConcurrentMap<String, WeakReference<File>> CURRENT_SWAP_FILES = new ConcurrentHashMap<String, WeakReference<File>>();
    protected final ConcurrentLinkedQueue<File> files = new ConcurrentLinkedQueue();
    private final Thread hook = new Thread(){

        @Override
        public void run() {
            File file = null;
            for (WeakReference swapFileRef : CURRENT_SWAP_FILES.values()) {
                FileCleaner.this.addFile(((File)swapFileRef.get()).getAbsoluteFile());
            }
            while ((file = FileCleaner.this.files.poll()) != null) {
                PrivilegedFileHelper.delete((File)file);
            }
        }
    };

    public FileCleaner() {
        this(30000L);
    }

    public FileCleaner(ExoContainerContext ctx) {
        this(null, ctx, 30000L);
    }

    public FileCleaner(long timeout) {
        this(timeout, true);
    }

    public FileCleaner(String prefix, ExoContainerContext ctx, long timeout) {
        this(ctx == null ? prefix : (prefix == null ? "" : prefix + " ") + ctx.getName(), timeout, true);
    }

    public FileCleaner(boolean start) {
        this(30000L, start);
    }

    public FileCleaner(long timeout, boolean start) {
        this(null, timeout, start);
    }

    public FileCleaner(String id, long timeout, boolean start) {
        super(timeout);
        this.setName("File Cleaner " + (id == null ? Long.valueOf(this.getId()) : id));
        this.setDaemon(true);
        this.setPriority(1);
        if (start) {
            this.start();
        }
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FileCleaner.this.registerShutdownHook();
                return null;
            }
        };
        SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("FileCleaner instantiated name= " + this.getName() + " timeout= " + timeout));
        }
    }

    public void addFile(File file) {
        if (PrivilegedFileHelper.exists((File)file)) {
            this.files.offer(file);
        }
    }

    public void removeFile(File file) {
        this.files.remove(file);
    }

    @Override
    public void halt() {
        block3: {
            try {
                this.callPeriodically();
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                block2: {
                    try {
                        Runtime.getRuntime().removeShutdownHook(FileCleaner.this.hook);
                    }
                    catch (IllegalStateException e) {
                        if (!LOG.isTraceEnabled()) break block2;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                return null;
            }
        });
        if (this.files != null && this.files.size() > 0) {
            LOG.warn((Object)("There are uncleared files: " + this.files.size()));
        }
        super.halt();
    }

    @Override
    protected void callPeriodically() throws Exception {
        File file = null;
        HashSet<File> notRemovedFiles = new HashSet<File>();
        while ((file = this.files.poll()) != null) {
            if (!PrivilegedFileHelper.exists((File)file)) continue;
            if (!PrivilegedFileHelper.delete((File)file)) {
                notRemovedFiles.add(file);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Could not delete " + (file.isDirectory() ? "directory" : "file") + ". Will try next time: " + PrivilegedFileHelper.getAbsolutePath((File)file)));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)((file.isDirectory() ? "Directory" : "File") + " deleted : " + PrivilegedFileHelper.getAbsolutePath((File)file)));
        }
        if (!notRemovedFiles.isEmpty()) {
            this.files.addAll(notRemovedFiles);
        }
    }

    private void registerShutdownHook() {
        block2: {
            try {
                Runtime.getRuntime().addShutdownHook(this.hook);
            }
            catch (IllegalStateException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
    }
}

