/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class SpaceIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(SpaceIndexingServiceConnector.class);
    private static final long serialVersionUID = 9141474534628715938L;
    public static final String TYPE = "space";
    private SpaceService spaceService;
    private SpaceStorage spaceStorage;

    public SpaceIndexingServiceConnector(InitParams initParams, SpaceService spaceService, SpaceStorage spaceStorage) {
        super(initParams);
        this.spaceService = spaceService;
        this.spaceStorage = spaceStorage;
    }

    public Document create(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        long ts = System.currentTimeMillis();
        LOG.debug("get space document for space id={}", new Object[]{id});
        Space space = this.spaceService.getSpaceById(id);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("prettyName", space.getPrettyName());
        fields.put("displayName", space.getDisplayName());
        fields.put("description", space.getDescription());
        fields.put("visibility", space.getVisibility());
        fields.put("registration", space.getRegistration());
        Date createdDate = new Date(space.getCreatedTime());
        Document document = new Document(TYPE, id, null, createdDate, new HashSet<String>(Arrays.asList(space.getMembers())), fields);
        LOG.info("space document generated for id={} name={} duration_ms={}", new Object[]{id, space.getPrettyName(), System.currentTimeMillis() - ts});
        return document;
    }

    public Document update(String id) {
        return this.create(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        LinkedList<String> ids = new LinkedList<String>();
        try {
            List<Space> spaces = this.spaceStorage.getAllSpaces();
            int to = offset + limit;
            to = to > spaces.size() ? spaces.size() : to;
            for (Space space : spaces.subList(offset, to)) {
                ids.add(space.getId());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        return ids;
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"prettyName\" : {\"type\" : \"keyword\"},\n").append("    \"displayName\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"description\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"visibility\" : {\"type\" : \"keyword\"},\n").append("    \"registration\" : {\"type\" : \"keyword\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }
}

