/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.InputStream;
import java.net.URL;
import javax.naming.InitialContext;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.SecureRandomProvider;
import org.picketlink.idm.api.cfg.IdentityConfiguration;
import org.picketlink.idm.common.exception.IdentityConfigurationException;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picocontainer.Startable;

public class PicketLinkIDMServiceImpl
implements PicketLinkIDMService,
Startable {
    private static Log log = ExoLogger.getLogger(PicketLinkIDMServiceImpl.class);
    public static final String PARAM_CONFIG_OPTION = "config";
    public static final String PARAM_JNDI_NAME_OPTION = "jndiName";
    public static final String PARAM_SKIP_EXPIRATION_STRUCTURE_CACHE_ENTRIES = "skipExpirationOfStructureCacheEntries";
    public static final String PARAM_USE_SECURE_RANDOM_SERVICE = "useSecureRandomService";
    public static final String PARAM_STALE_CACHE_NODES_LINKS_CLEANER_DELAY = "staleCacheNodesLinksCleanerDelay";
    public static final int DEFAULT_STALE_CACHE_NODES_LINKS_CLEANER_DELAY = 120000;
    public static final String REALM_NAME_OPTION = "portalRealm";
    public static final String CACHE_CONFIG_API_OPTION = "apiCacheConfig";
    public static final String CACHE_CONFIG_STORE_OPTION = "storeCacheConfig";
    private IdentitySessionFactory identitySessionFactory;
    private String config;
    private String realmName = "idm_realm";
    private IdentityConfiguration identityConfiguration;
    private IdentityConfigurationMetaData configMD;
    private HibernateService hibernateService;

    public PicketLinkIDMServiceImpl(ExoContainerContext exoContainerContext, InitParams initParams, HibernateService hibernateService, ConfigurationManager confManager, InitialContextInitializer dependency) throws Exception {
        boolean skipExpirationOfStructureCacheEntries;
        ValueParam config = initParams.getValueParam(PARAM_CONFIG_OPTION);
        ValueParam jndiName = initParams.getValueParam(PARAM_JNDI_NAME_OPTION);
        ValueParam canExpireStructureCacheEntriesParam = initParams.getValueParam(PARAM_SKIP_EXPIRATION_STRUCTURE_CACHE_ENTRIES);
        ValueParam staleCacheNodesLinksCleanerDelayParam = initParams.getValueParam(PARAM_STALE_CACHE_NODES_LINKS_CLEANER_DELAY);
        ValueParam realmName = initParams.getValueParam(REALM_NAME_OPTION);
        ValueParam apiCacheConfig = initParams.getValueParam(CACHE_CONFIG_API_OPTION);
        ValueParam storeCacheConfig = initParams.getValueParam(CACHE_CONFIG_STORE_OPTION);
        ValueParam useSecureRandomService = initParams.getValueParam(PARAM_USE_SECURE_RANDOM_SERVICE);
        this.hibernateService = hibernateService;
        if (config == null && jndiName == null) {
            throw new IllegalStateException("Either 'config' or 'jndiName' parameter must be specified");
        }
        if (realmName != null) {
            this.realmName = realmName.getValue();
        }
        long staleCacheNodesLinksCleanerDelay = staleCacheNodesLinksCleanerDelayParam == null ? 120000L : Long.parseLong(staleCacheNodesLinksCleanerDelayParam.getValue());
        boolean bl = skipExpirationOfStructureCacheEntries = canExpireStructureCacheEntriesParam != null && "true".equals(canExpireStructureCacheEntriesParam.getValue());
        if (config != null) {
            InputStream configStream;
            this.config = config.getValue();
            URL configURL = confManager.getURL(this.config);
            if (configURL == null) {
                throw new IllegalStateException("Cannot fine resource: " + this.config);
            }
            this.configMD = JAXB2IdentityConfiguration.createConfigurationMetaData((InputStream)confManager.getInputStream(this.config));
            this.identityConfiguration = new IdentityConfigurationImpl().configure(this.configMD);
            this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)hibernateService.getSessionFactory(), "hibernateSessionFactory");
            if (apiCacheConfig != null) {
                log.warn((Object)"The parameter 'apiCacheProvider' has been deprecated. It has been replaced by caches in Organization Service top layer. Thus, the parameter should be removed.");
                configStream = confManager.getInputStream(apiCacheConfig.getValue());
                if (configStream == null) {
                    throw new IllegalArgumentException("Infinispan configuration InputStream is null");
                }
                configStream.close();
            }
            if (storeCacheConfig != null) {
                log.warn((Object)"The parameter 'storeCacheProvider' has been deprecated. It has been replaced by caches in Organization Service top layer. Thus, the parameter should be removed.");
                configStream = confManager.getInputStream(storeCacheConfig.getValue());
                if (configStream == null) {
                    throw new IllegalArgumentException("Infinispan configuration InputStream is null");
                }
            }
            if (useSecureRandomService != null && "true".equals(useSecureRandomService.getValue())) {
                SecureRandomProvider secureRandomProvider = (SecureRandomProvider)exoContainerContext.getContainer().getComponentInstanceOfType(SecureRandomProvider.class);
                this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)secureRandomProvider, "secureRandomProvider");
            }
        } else {
            this.identitySessionFactory = (IdentitySessionFactory)new InitialContext().lookup(jndiName.getValue());
        }
    }

    public void start() {
        if (this.identitySessionFactory == null) {
            try {
                this.identitySessionFactory = this.identityConfiguration.buildIdentitySessionFactory();
            }
            catch (IdentityConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stop() {
    }

    @Override
    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    @Override
    public IdentitySession getIdentitySession() throws Exception {
        if (this.getIdentitySessionFactory() != null) {
            return this.getIdentitySessionFactory().getCurrentIdentitySession(this.realmName);
        }
        return null;
    }

    @Override
    public IdentitySession getIdentitySession(String realm) throws Exception {
        if (realm == null) {
            throw new IllegalArgumentException("Realm name cannot be null");
        }
        return this.getIdentitySessionFactory().getCurrentIdentitySession(realm);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public HibernateService getHibernateService() {
        return this.hibernateService;
    }

    public IdentityConfigurationMetaData getConfigMD() {
        return this.configMD;
    }

    public void setConfigMD(IdentityConfigurationMetaData configMD) {
        this.configMD = configMD;
    }
}

