/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.cataloggen.StandardCatalogBuilder;
import thredds.cataloggen.catalogrefexpander.BooleanCatalogRefExpander;
import thredds.cataloggen.datasetenhancer.RegExpAndDurationTimeCoverageEnhancer;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.filter.MultiSelectorFilter;
import thredds.crawlabledataset.filter.RegExpMatchOnNameFilter;
import thredds.crawlabledataset.sorter.LexigraphicByNameSorter;

public class DirectoryScanner {
    private static Logger logger = LoggerFactory.getLogger(DirectoryScanner.class);
    private String serviceTitle;
    private File serviceBaseUrlDir;
    private CrawlableDataset collectionCrDs;
    private String prefixPath;
    private boolean createCatalogRefs = true;
    private InvService service;

    public DirectoryScanner(InvService service, String serviceTitle, File serviceBaseUrlDir, String prefixPath, boolean createCatalogRefs) {
        this.service = service;
        this.serviceTitle = serviceTitle;
        this.serviceBaseUrlDir = serviceBaseUrlDir;
        try {
            this.collectionCrDs = CrawlableDatasetFactory.createCrawlableDataset(serviceBaseUrlDir.getAbsolutePath(), null, null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while creating dataset: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Did not find class: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Required constructor not found in class: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Did not have necessary access to class: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not invoke required method in class: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instatiate class: " + e.getMessage());
        }
        if (!this.collectionCrDs.isCollection()) {
            throw new IllegalArgumentException("Base URL directory is not a directory <" + serviceBaseUrlDir.getAbsolutePath() + ">.");
        }
        this.prefixPath = prefixPath;
        this.createCatalogRefs = createCatalogRefs;
    }

    public InvCatalog getDirCatalog(File directory, String filterPattern, boolean sortInIncreasingOrder, boolean addDatasetSize) {
        return this.getDirCatalog(directory, filterPattern, sortInIncreasingOrder, null, addDatasetSize, null, null, null);
    }

    public InvCatalog getDirCatalog(File directory, String filterPattern, boolean sortInIncreasingOrder, String addIdBase, boolean addDatasetSize, String dsNameMatchPattern, String startTimeSubstitutionPattern, String duration) {
        CrawlableDataset catalogCrDs;
        try {
            catalogCrDs = CrawlableDatasetFactory.createCrawlableDataset(directory.getAbsolutePath(), null, null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while creating dataset: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Did not find class: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Required constructor not found in class: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Did not have necessary access to class: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not invoke required method in class: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instatiate class: " + e.getMessage());
        }
        if (!catalogCrDs.isCollection()) {
            throw new IllegalArgumentException("catalog directory is not a directory <" + this.serviceBaseUrlDir.getAbsolutePath() + ">.");
        }
        return this.getDirCatalog(catalogCrDs, filterPattern, sortInIncreasingOrder, addIdBase, addDatasetSize, dsNameMatchPattern, startTimeSubstitutionPattern, duration);
    }

    public InvCatalog getDirCatalog(CrawlableDataset catalogCrDs, String filterPattern, boolean sortInIncreasingOrder, String addIdBase, boolean addDatasetSize, String dsNameMatchPattern, String startTimeSubstitutionPattern, String duration) {
        InvCatalogImpl catalog;
        CrawlableDatasetFilter filter = null;
        if (filterPattern != null) {
            MultiSelectorFilter.Selector selector = new MultiSelectorFilter.Selector(new RegExpMatchOnNameFilter(filterPattern), true, true, false);
            filter = new MultiSelectorFilter(selector);
        } else {
            filter = new RegExpMatchOnNameFilter(".*");
        }
        ArrayList<RegExpAndDurationTimeCoverageEnhancer> enhancerList = null;
        if (dsNameMatchPattern != null && startTimeSubstitutionPattern != null && duration != null) {
            enhancerList = new ArrayList<RegExpAndDurationTimeCoverageEnhancer>();
            enhancerList.add(RegExpAndDurationTimeCoverageEnhancer.getInstanceToMatchOnDatasetName(dsNameMatchPattern, startTimeSubstitutionPattern, duration));
        }
        StandardCatalogBuilder catBuilder = new StandardCatalogBuilder(this.prefixPath, null, this.collectionCrDs, filter, this.service, addIdBase, null, null, addDatasetSize, new LexigraphicByNameSorter(sortInIncreasingOrder), null, enhancerList, null, new BooleanCatalogRefExpander(!this.createCatalogRefs));
        try {
            catalog = catBuilder.generateCatalog(catalogCrDs);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not generate catalog: " + e.getMessage());
        }
        InvDataset topDs = catalog.getDataset();
        if (this.collectionCrDs.getPath().equals(catalogCrDs.getPath()) && this.serviceTitle != null) {
            logger.warn("getDirCatalog(): top dataset name is null, setting to serviceTitle <" + this.serviceTitle + ">");
            ((InvDatasetImpl)topDs).setName(this.serviceTitle);
        }
        return catalog;
    }
}

