/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.module.ModuleRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortletDisablerFilter
implements RenderFilter {
    private static final Log LOG = ExoLogger.getLogger(PortletDisablerFilter.class);
    private static final Map<String, Boolean> PORTLET_STATUS = new ConcurrentHashMap<String, Boolean>();
    private ModuleRegistry moduleRegistry = null;
    private String contextName = null;

    public void init(FilterConfig filterConfig) throws PortletException {
        PortletContext context = filterConfig.getPortletContext();
        this.contextName = context.getPortletContextName();
    }

    public void doFilter(RenderRequest request, RenderResponse response, FilterChain chain) throws IOException, PortletException {
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        if (portletConfig == null) {
            chain.doFilter(request, response);
            return;
        }
        String portletName = portletConfig.getPortletName();
        Boolean enabled = this.isPortletEnabled(portletName);
        if (enabled != null) {
            if (enabled.booleanValue()) {
                chain.doFilter(request, response);
            }
            return;
        }
        String configuredPortletProfiles = portletConfig.getInitParameter("exo.profiles");
        if (StringUtils.isNotBlank((CharSequence)configuredPortletProfiles)) {
            String[] portletProfiles = configuredPortletProfiles.trim().split(" *, *");
            Set activeProfiles = ExoContainer.getProfiles();
            enabled = Arrays.stream(portletProfiles).anyMatch(activeProfiles::contains);
            if (Boolean.FALSE.equals(enabled)) {
                this.setPortletEnabled(portletName, enabled);
                LOG.debug("Portlet '{}' is disabled because none of profiles '{}' exists in portal container", new Object[]{portletConfig.getPortletName(), configuredPortletProfiles});
                return;
            }
            LOG.debug("Portlet '{}' is enable because one of profiles '{}' exists in portal container", new Object[]{portletConfig.getPortletName(), configuredPortletProfiles});
        }
        String applicationId = this.contextName + "/" + portletName;
        enabled = this.getModuleRegistry().isPortletActive(applicationId);
        this.setPortletEnabled(portletName, enabled);
        if (enabled.booleanValue()) {
            chain.doFilter(request, response);
        } else {
            LOG.debug("Portlet '{}' is disabled", new Object[]{applicationId});
        }
    }

    private Boolean isPortletEnabled(String portletName) {
        return PORTLET_STATUS.get(portletName);
    }

    private void setPortletEnabled(String portletName, boolean enabled) {
        PORTLET_STATUS.put(portletName, enabled);
    }

    public void destroy() {
    }

    private ModuleRegistry getModuleRegistry() {
        if (this.moduleRegistry == null) {
            this.moduleRegistry = (ModuleRegistry)PortalContainer.getComponent(ModuleRegistry.class);
        }
        return this.moduleRegistry;
    }
}

