/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPageActionListener;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplicationLifecycle;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMap;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIPortalApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl", events={@EventConfig(listeners={UIPageActionListener.ChangeNodeActionListener.class}, csrfCheck=false)})
public class UIPortalApplication
extends UIApplication {
    public static final String DEFAULT_MODE_PROPERTY = "gatein.portal.pageEditor.defaultEditMode";
    public static final String PORTAL_PORTLETS_SKIN_ID = "portalPortletSkins";
    public static final int NORMAL_MODE = 0;
    public static final int APP_BLOCK_EDIT_MODE = 1;
    public static final int APP_VIEW_EDIT_MODE = 2;
    public static final int CONTAINER_BLOCK_EDIT_MODE = 3;
    public static final int CONTAINER_VIEW_EDIT_MODE = 4;
    public static final UIComponent EMPTY_COMPONENT = new UIComponent(){

        public String getId() {
            return "_portal:componentId_";
        }
    };
    private static EditMode defaultEditMode = null;
    private int modeState = 0;
    private EditLevel editLevel = EditLevel.NO_EDIT;
    private Orientation orientation_ = Orientation.LT;
    public static final String UI_WORKING_WS_ID = "UIWorkingWorkspace";
    public static final String UI_VIEWING_WS_ID = "UIViewWS";
    public static final String UI_EDITTING_WS_ID = "UIEditInlineWS";
    public static final String UI_MASK_WS_ID = "UIMaskWorkspace";
    private SkinService skinService;
    private SkinVisitor skinVisitor;
    private DataStorage dataStorage;
    private String skin_;
    private boolean isSessionOpen = false;
    private Map<SiteKey, UIPortal> all_UIPortals;
    private UIPortal currentSite;
    private boolean isAjaxInLastRequest;
    private RequestNavigationData lastNonAjaxRequestNavData;
    private RequestNavigationData lastRequestNavData;
    private UIWorkingWorkspace uiWorkingWorkspace;
    private UIComponentDecorator uiViewWorkingWorkspace;
    private String lastPortal;
    private String lastPortalOwner;

    public static EditMode getDefaultEditMode() {
        if (defaultEditMode == null) {
            String val = PropertyManager.getProperty((String)DEFAULT_MODE_PROPERTY);
            if (val == null || val.length() == 0) {
                defaultEditMode = EditMode.BLOCK;
            } else {
                try {
                    defaultEditMode = EditMode.valueOf(val.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    StringBuilder msg = new StringBuilder().append("Ignoring illegal value '").append(val).append("' of ").append(DEFAULT_MODE_PROPERTY).append(" property in configuration.properties. One of [");
                    for (EditMode mode : EditMode.values()) {
                        if (msg.charAt(msg.length() - 1) != '[') {
                            msg.append(", ");
                        }
                        msg.append(mode.name());
                    }
                    msg.append("] is expected. Using default value '").append(EditMode.BLOCK.name()).append("'.");
                    log.warn((Object)msg.toString());
                    defaultEditMode = EditMode.BLOCK;
                }
            }
        }
        return defaultEditMode;
    }

    public UIPortalApplication() throws Exception {
        String localeName;
        LocaleConfig localeConfig;
        log = ExoLogger.getLogger((String)"portal:UIPortalApplication");
        PortalRequestContext context = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
        this.skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        this.skinVisitor = (SkinVisitor)this.getApplicationComponent(SkinVisitor.class);
        this.dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Locale locale = context.getLocale();
        if (locale == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No locale set on PortalRequestContext! Falling back to 'en'.");
            }
            locale = Locale.ENGLISH;
        }
        if ((localeConfig = localeConfigService.getLocaleConfig(localeName = LocaleContextInfo.getLocaleAsString((Locale)locale))) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported locale set on PortalRequestContext: " + localeName + "! Falling back to 'en'."));
            }
            localeConfig = localeConfigService.getLocaleConfig(Locale.ENGLISH.getLanguage());
        }
        this.setOrientation(localeConfig.getOrientation());
        context.setUIApplication(this);
        this.all_UIPortals = new HashMap<SiteKey, UIPortal>(5);
        JavascriptManager jsMan = context.getJavascriptManager();
        this.lastPortalOwner = context.getPortalOwner();
        this.initWorkspaces();
    }

    public void setCurrentSite(UIPortal uiPortal) {
        this.currentSite = uiPortal;
        UISiteBody siteBody = (UISiteBody)this.findFirstComponentOfType(UISiteBody.class);
        if (siteBody != null) {
            siteBody.setUIComponent((UIComponent)uiPortal);
        }
    }

    public UIPortal getCurrentSite() {
        return this.currentSite;
    }

    public UIPortal getCachedUIPortal(String ownerType, String ownerId) {
        if (ownerType == null || ownerId == null) {
            return null;
        }
        return this.all_UIPortals.get(new SiteKey(ownerType, ownerId));
    }

    public UIPortal getCachedUIPortal(SiteKey key) {
        if (key == null) {
            return null;
        }
        return this.all_UIPortals.get(key);
    }

    public void putCachedUIPortal(UIPortal uiPortal) {
        SiteKey siteKey = uiPortal.getSiteKey();
        if (siteKey != null) {
            this.all_UIPortals.put(siteKey, uiPortal);
        }
    }

    public void removeCachedUIPortal(String ownerType, String ownerId) {
        if (ownerType == null || ownerId == null) {
            return;
        }
        this.all_UIPortals.remove(new SiteKey(ownerType, ownerId));
    }

    public void invalidateUIPage(String pageRef) {
        for (UIPortal tmp : this.all_UIPortals.values()) {
            tmp.clearUIPage(pageRef);
        }
    }

    public void refreshCachedUI() throws Exception {
        this.all_UIPortals.clear();
        UIPortal uiPortal = this.getCurrentSite();
        if (uiPortal != null) {
            SiteKey siteKey = uiPortal.getSiteKey();
            UIPortal tmp = null;
            PortalConfig portalConfig = this.dataStorage.getPortalConfig(siteKey.getTypeName(), siteKey.getName());
            if (portalConfig != null) {
                PortalRequestContext pcontext;
                tmp = (UIPortal)this.createUIComponent(UIPortal.class, null, null);
                PortalDataMapper.toUIPortal(tmp, portalConfig);
                this.putCachedUIPortal(tmp);
                tmp.setNavPath(uiPortal.getNavPath());
                tmp.refreshUIPage();
                this.setCurrentSite(tmp);
                if (SiteType.PORTAL.equals((Object)siteKey.getType()) && (pcontext = Util.getPortalRequestContext()) != null) {
                    UserPortalConfig userPortalConfig = pcontext.getUserPortalConfig();
                    userPortalConfig.setPortalConfig(portalConfig);
                }
            }
        }
    }

    public boolean isSessionOpen() {
        return this.isSessionOpen;
    }

    public void setSessionOpen(boolean isSessionOpen) {
        this.isSessionOpen = isSessionOpen;
    }

    public Orientation getOrientation() {
        return this.orientation_;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation_ = orientation;
    }

    public Locale getLocale() {
        return Util.getPortalRequestContext().getLocale();
    }

    public void setModeState(int mode) {
        this.modeState = mode;
        if (this.modeState == 0) {
            this.editLevel = EditLevel.NO_EDIT;
        }
    }

    public void setDefaultEditMode(ComponentTab componentTab, EditLevel editLevel) {
        this.editLevel = editLevel;
        EditMode editMode = UIPortalApplication.getDefaultEditMode();
        block0 : switch (componentTab) {
            case APPLICATIONS: {
                switch (editMode) {
                    case BLOCK: {
                        this.modeState = 1;
                        break block0;
                    }
                    case PREVIEW: {
                        this.modeState = 2;
                        break block0;
                    }
                }
                log.warn((Object)("Ignoring unexpected " + EditMode.class.getName() + " value '" + editMode.name() + "' and using '" + EditMode.BLOCK.name() + "'."));
                break;
            }
            case CONTAINERS: {
                switch (editMode) {
                    case BLOCK: {
                        this.modeState = 3;
                        break block0;
                    }
                    case PREVIEW: {
                        this.modeState = 4;
                        break block0;
                    }
                }
                log.warn((Object)("Ignoring unexpected " + EditMode.class.getName() + " value '" + editMode.name() + "' and using '" + EditMode.BLOCK.name() + "'."));
                break;
            }
            default: {
                log.warn((Object)("Ignoring unexpected " + ComponentTab.class.getName() + " value '" + componentTab.name() + "' and using '" + ComponentTab.APPLICATIONS.name() + "'."));
                switch (editMode) {
                    case BLOCK: {
                        this.modeState = 1;
                        break block0;
                    }
                    case PREVIEW: {
                        this.modeState = 2;
                        break block0;
                    }
                }
                log.warn((Object)("Ignoring unexpected " + EditMode.class.getName() + " value '" + editMode.name() + "' and using '" + EditMode.BLOCK.name() + "'."));
            }
        }
    }

    public int getModeState() {
        return this.modeState;
    }

    public void setLastRequestNavData(RequestNavigationData navData) {
        this.lastRequestNavData = navData;
    }

    public boolean isEditing() {
        return this.modeState != 0;
    }

    public Map<String, Boolean> getScripts() {
        PortalRequestContext prc = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
        JavascriptManager jsMan = prc.getJavascriptManager();
        FetchMap requiredResources = jsMan.getScriptResources();
        log.debug("Resource ids to resolve: {}", new Object[]{requiredResources});
        JavascriptConfigService service = (JavascriptConfigService)this.getApplicationComponent(JavascriptConfigService.class);
        LinkedHashMap<String, Boolean> ret = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, Boolean> tmp = new LinkedHashMap<String, Boolean>();
        Map resolved = service.resolveIds((Map)requiredResources);
        for (ScriptResource rs : resolved.keySet()) {
            ResourceId id = rs.getId();
            if (ResourceScope.SHARED.equals((Object)id.getScope()) && "bootstrap".equals(id.getName())) {
                ret.put(id.toString(), false);
                continue;
            }
            boolean isRemote = !rs.isEmpty() && rs.getModules().get(0) instanceof Module.Remote;
            tmp.put(id.toString(), isRemote);
        }
        ret.putAll(tmp);
        for (String url : jsMan.getExtendedScriptURLs()) {
            ret.put(url, true);
        }
        log.debug((Object)("Resolved resources for page: " + ret));
        return ret;
    }

    public JSONObject getJSConfig() throws Exception {
        JavascriptConfigService service = (JavascriptConfigService)this.getApplicationComponent(JavascriptConfigService.class);
        PortalRequestContext prc = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
        return service.getJSConfig(prc.getControllerContext(), prc.getLocale());
    }

    public Collection<SkinConfig> getPortalSkins(SkinVisitor visitor) {
        if (visitor != null) {
            Collection skins = this.skinService.findSkins(visitor);
            return skins;
        }
        return Collections.emptyList();
    }

    public Collection<SkinConfig> getPortalSkins() {
        Collection<SkinConfig> skins = null;
        skins = this.skinVisitor == null ? new ArrayList<SkinConfig>(this.skinService.getPortalSkins(this.skin_)) : this.getPortalSkins(this.skinVisitor);
        SkinConfig skinConfig = this.skinService.getSkin(Util.getUIPortal().getName(), this.skin_);
        if (skinConfig != null) {
            skins.add(skinConfig);
        }
        return skins;
    }

    private Set<SkinConfig> getPortalPortletSkins() {
        HashSet<SkinConfig> portletConfigs = new HashSet<SkinConfig>();
        for (UIComponent child : Util.getUIPortal().getChildren()) {
            this.getPortalPortletSkinConfig(portletConfigs, child);
        }
        return portletConfigs;
    }

    private Collection<SkinConfig> getCustomSkins() {
        return this.skinService.getCustomPortalSkins(this.skin_);
    }

    private void getPortalPortletSkinConfig(Set<SkinConfig> portletConfigs, UIComponent component) {
        if (component instanceof UIPortlet) {
            SkinConfig portletConfig = this.getPortletSkinConfig((UIPortlet)component);
            if (portletConfig != null) {
                portletConfigs.add(portletConfig);
            }
        } else if (component instanceof org.exoplatform.webui.core.UIContainer) {
            for (UIComponent child : ((org.exoplatform.webui.core.UIContainer)component).getChildren()) {
                this.getPortalPortletSkinConfig(portletConfigs, child);
            }
        }
    }

    public String getSkin() {
        return this.skin_;
    }

    public void setSkin(String skin) {
        this.skin_ = skin;
    }

    public Set<Skin> getPortletSkins() {
        ArrayList uiportlets = new ArrayList();
        this.uiWorkingWorkspace.findComponentOfType(uiportlets, UIPortlet.class);
        UIPortalToolPanel toolPanel = (UIPortalToolPanel)this.uiWorkingWorkspace.findFirstComponentOfType(UIPortalToolPanel.class);
        if (toolPanel != null && toolPanel.isRendered()) {
            toolPanel.findComponentOfType(uiportlets, UIPortlet.class);
        }
        ArrayList<Object> portletSkins = new ArrayList<Object>();
        Set<SkinConfig> portalPortletSkins = this.getPortalPortletSkins();
        if (!portalPortletSkins.isEmpty()) {
            portletSkins.add(this.skinService.merge(portalPortletSkins, PORTAL_PORTLETS_SKIN_ID));
        }
        for (UIPortlet uiPortlet : uiportlets) {
            SkinConfig skinConfig = this.getPortletSkinConfig(uiPortlet);
            if (skinConfig == null || portalPortletSkins.contains(skinConfig)) continue;
            portletSkins.add(skinConfig);
        }
        Collections.sort(portletSkins, new Comparator<Skin>(){

            @Override
            public int compare(Skin s1, Skin s2) {
                if (s1 instanceof SkinConfig && s2 instanceof SkinConfig) {
                    SkinConfig o1 = (SkinConfig)s1;
                    SkinConfig o2 = (SkinConfig)s2;
                    if (o1.getCSSPriority() == o2.getCSSPriority()) {
                        return 1;
                    }
                    if (o1.getCSSPriority() < 0) {
                        return 1;
                    }
                    if (o2.getCSSPriority() < 0) {
                        return -1;
                    }
                    return o1.getCSSPriority() - o2.getCSSPriority();
                }
                return 0;
            }
        });
        return new HashSet<Skin>(portletSkins);
    }

    private SkinConfig getPortletSkinConfig(UIPortlet portlet) {
        String portletId = portlet.getSkinId();
        if (portletId != null) {
            return this.skinService.getSkin(portletId, this.skin_);
        }
        return null;
    }

    private void initWorkspaces() throws Exception {
        if (this.getChildById(UI_WORKING_WS_ID) != null) {
            this.removeChildById(UI_WORKING_WS_ID);
        }
        this.uiWorkingWorkspace = (UIWorkingWorkspace)this.addChild(UIWorkingWorkspace.class, UI_WORKING_WS_ID, null);
        ((UIEditInlineWorkspace)this.uiWorkingWorkspace.addChild(UIEditInlineWorkspace.class, null, UI_EDITTING_WS_ID)).setRendered(false);
        this.uiViewWorkingWorkspace = (UIComponentDecorator)this.uiWorkingWorkspace.addChild(UIComponentDecorator.class, null, UI_VIEWING_WS_ID);
        if (this.getChildById(UI_MASK_WS_ID) == null) {
            this.addChild(UIMaskWorkspace.class, UI_MASK_WS_ID, null);
        }
        this.initSharedLayout();
    }

    private void initSharedLayout() throws Exception {
        Container container = this.dataStorage.getSharedLayout(this.lastPortalOwner);
        if (container != null) {
            UIContainer uiContainer = (UIContainer)this.createUIComponent(UIContainer.class, null, null);
            uiContainer.setStorageId(container.getStorageId());
            PortalDataMapper.toUIContainer(uiContainer, container);
            uiContainer.setRendered(true);
            this.uiViewWorkingWorkspace.setUIComponent((UIComponent)uiContainer);
        }
        this.refreshCachedUI();
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        PortalRequestContext prc = (PortalRequestContext)context;
        String portalName = prc.getUserPortalConfig().getPortalName();
        if (!Safe.equals((Object)portalName, (Object)this.lastPortal)) {
            this.reloadPortalProperties();
            this.lastPortal = portalName;
        }
        super.processDecode(context);
    }

    public void processAction(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        RequestNavigationData requestNavData = pcontext.getNavigationData();
        boolean isAjax = pcontext.useAjax();
        if (!isAjax) {
            if (this.isAjaxInLastRequest) {
                this.isAjaxInLastRequest = false;
                if (requestNavData.equals(this.lastNonAjaxRequestNavData) && !requestNavData.equals(this.lastRequestNavData)) {
                    NodeURL nodeURL = ((NodeURL)pcontext.createURL(NodeURL.TYPE)).setNode(this.getCurrentSite().getSelectedUserNode());
                    pcontext.sendRedirect(nodeURL.toString());
                    return;
                }
            }
            this.lastNonAjaxRequestNavData = requestNavData;
        }
        this.isAjaxInLastRequest = isAjax;
        if (!requestNavData.equals(this.lastRequestNavData)) {
            this.lastRequestNavData = requestNavData;
            StringBuilder js = new StringBuilder("eXo.env.server.portalBaseURL=\"");
            js.append(this.getBaseURL()).append("\";\n");
            String url = this.getPortalURLTemplate();
            js.append("eXo.env.server.portalURLTemplate=\"");
            js.append(url).append("\";");
            pcontext.getJavascriptManager().require("SHARED/base").addScripts(js.toString());
            SiteKey siteKey = new SiteKey(pcontext.getSiteType(), pcontext.getSiteName());
            PageNodeEvent<UIPortalApplication> pnevent = new PageNodeEvent<UIPortalApplication>(this, "ChangeNode", siteKey, pcontext.getNodePath());
            this.broadcast(pnevent, Event.Phase.PROCESS);
        }
        if (!isAjax) {
            this.lastNonAjaxRequestNavData = requestNavData;
        }
        if (pcontext.isResponseComplete()) {
            return;
        }
        if (this.currentSite == null || this.currentSite.getSelectedUserNode() == null) {
            pcontext.sendError(404);
        }
        super.processAction((WebuiRequestContext)pcontext);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        if (!StringUtils.equals((String)this.lastPortalOwner, (String)pcontext.getPortalOwner())) {
            this.lastPortalOwner = pcontext.getPortalOwner();
            this.initWorkspaces();
        }
        JavascriptManager jsMan = context.getJavascriptManager();
        String portalOwner = pcontext.getPortalOwner();
        jsMan.loadScriptResource(ResourceScope.PORTAL, portalOwner);
        Writer w = context.getWriter();
        if (!context.useAjax()) {
            jsMan.loadScriptResource(ResourceScope.SHARED, "merged");
            jsMan.loadScriptResource(ResourceScope.SHARED, "bootstrap");
            super.processRender(context);
        } else {
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)this.getChildById(UI_MASK_WS_ID);
            if (uiMaskWS.isUpdated()) {
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            }
            if (this.getUIPopupMessages().hasMessage()) {
                pcontext.addUIComponentToUpdateByAjax((UIComponent)this.getUIPopupMessages());
            }
            Set list = context.getUIComponentToUpdateByAjax();
            ArrayList<UIPortlet> uiPortlets = new ArrayList<UIPortlet>(3);
            ArrayList<UIComponent> uiDataComponents = new ArrayList<UIComponent>(5);
            if (list != null) {
                for (UIComponent uIComponent : list) {
                    if (uIComponent instanceof UIPortlet) {
                        uiPortlets.add((UIPortlet)uIComponent);
                        continue;
                    }
                    uiDataComponents.add(uIComponent);
                }
            }
            w.write("<div class=\"PortalResponse\">");
            w.write("<div class=\"PortalResponseData\">");
            for (UIComponent uIComponent : uiDataComponents) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AJAX call: Need to refresh the UI component " + uIComponent.getName()));
                }
                this.renderBlockToUpdate(uIComponent, context, w);
            }
            w.write("</div>");
            if (!context.getFullRender()) {
                for (UIPortlet uIPortlet : uiPortlets) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AJAX call: Need to refresh the Portlet " + uIPortlet.getId()));
                    }
                    w.write("<div class=\"PortletResponse\" style=\"display: none\">");
                    w.append("<div class=\"PortletResponsePortletId\">" + uIPortlet.getId() + "</div>");
                    w.append("<div class=\"PortletResponseData\">");
                    uIPortlet.processRender(context);
                    w.append("</div>");
                    w.append("<div class=\"PortletResponseScript\"></div>");
                    w.write("</div>");
                }
            }
            w.write("<div class=\"MarkupHeadElements\">");
            List<String> headElems = ((PortalRequestContext)context).getExtraMarkupHeadersAsStrings();
            for (String elem : headElems) {
                w.write(elem);
            }
            w.write("</div>");
            w.write("<div class=\"LoadingScripts\">");
            this.writeLoadingScripts(pcontext);
            w.write("</div>");
            w.write("<div class=\"PortalResponseScript\">");
            JavascriptManager javascriptManager = pcontext.getJavascriptManager();
            String skin = this.getAddSkinScript(pcontext.getControllerContext(), list);
            if (skin != null) {
                javascriptManager.require("SHARED/skin", "skin").addScripts(skin);
            }
            w.write(javascriptManager.getJavaScripts());
            w.write("</div>");
            w.write("</div>");
        }
    }

    private void writeLoadingScripts(PortalRequestContext context) throws Exception {
        Writer w = context.getWriter();
        Map<String, Boolean> scriptURLs = this.getScripts();
        w.write("<div class=\"ImmediateScripts\">");
        w.write(StringUtils.join(scriptURLs.keySet(), (String)","));
        w.write("</div>");
    }

    private String getAddSkinScript(ControllerContext context, Set<UIComponent> updateComponents) {
        if (updateComponents == null) {
            return null;
        }
        ArrayList uiportlets = new ArrayList();
        for (UIComponent uicomponent : updateComponents) {
            UIComponentDecorator uiDecorator;
            if (uicomponent instanceof org.exoplatform.webui.core.UIContainer) {
                org.exoplatform.webui.core.UIContainer uiContainer = (org.exoplatform.webui.core.UIContainer)uicomponent;
                uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
            }
            if (!(uicomponent instanceof UIComponentDecorator) || !((uiDecorator = (UIComponentDecorator)uicomponent).getUIComponent() instanceof org.exoplatform.webui.core.UIContainer)) continue;
            org.exoplatform.webui.core.UIContainer uiContainer = (org.exoplatform.webui.core.UIContainer)uiDecorator.getUIComponent();
            uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
        }
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        Set<SkinConfig> portalPortletSkins = this.getPortalPortletSkins();
        boolean reloadPortalPortletSkins = false;
        for (Object uiPortlet : uiportlets) {
            SkinConfig skinConfig;
            String skinId = uiPortlet.getSkinId();
            if (skinId == null || (skinConfig = this.skinService.getSkin(skinId, this.skin_)) == null) continue;
            if (portalPortletSkins.contains(skinConfig)) {
                reloadPortalPortletSkins = true;
                continue;
            }
            skins.add(skinConfig);
        }
        StringBuilder b = new StringBuilder(1000);
        for (SkinConfig ele : skins) {
            SkinURL url = ele.createURL(context);
            url.setOrientation(this.orientation_);
            b.append("skin.addSkin('").append(ele.getId()).append("','").append(url).append("');\n");
        }
        if (reloadPortalPortletSkins) {
            Skin skin = this.skinService.merge(portalPortletSkins, PORTAL_PORTLETS_SKIN_ID);
            SkinURL url = skin.createURL(context);
            url.setOrientation(this.orientation_);
            b.append("skin.addSkin('").append(skin.getId()).append("','").append(url).append("', true);\n");
        }
        return b.toString();
    }

    @Deprecated
    public UserPortalConfig getUserPortalConfig() {
        return Util.getPortalRequestContext().getUserPortalConfig();
    }

    @Deprecated
    public void setUserPortalConfig(UserPortalConfig userPortalConfig) {
        Util.getPortalRequestContext().setUserPortalConfig(userPortalConfig);
    }

    public void reloadPortalProperties() throws Exception {
        String userPortalConfigSkin;
        PortalRequestContext context = Util.getPortalRequestContext();
        String user = context.getRemoteUser();
        String portalSkin = null;
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        if (user != null) {
            UserProfile userProfile = orgService.getUserProfileHandler().findUserProfileByName(user);
            if (userProfile != null) {
                portalSkin = (String)userProfile.getUserInfoMap().get("user.skin");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Could not load user profile for " + user + ". Using default portal locale."));
            }
        }
        this.skin_ = portalSkin != null && portalSkin.trim().length() > 0 ? portalSkin : ((userPortalConfigSkin = context.getUserPortalConfig().getPortalConfig().getSkin()) != null && userPortalConfigSkin.trim().length() > 0 ? userPortalConfigSkin : this.skinService.getDefaultSkin());
    }

    public String getPortalURLTemplate() throws UnsupportedEncodingException {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        ComponentURL urlTemplate = (ComponentURL)pcontext.createURL(ComponentURL.TYPE);
        urlTemplate.setMimeType(MimeType.PLAIN);
        urlTemplate.setPath(pcontext.getNodePath());
        urlTemplate.setResource(EMPTY_COMPONENT);
        urlTemplate.setAction("_portal:action_");
        return urlTemplate.toString();
    }

    public String getBaseURL() throws UnsupportedEncodingException {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        NodeURL nodeURL = (NodeURL)pcontext.createURL(NodeURL.TYPE, new NavigationResource(pcontext.getSiteKey(), pcontext.getNodePath()));
        return nodeURL.toString();
    }

    public EditLevel getEditLevel() {
        return this.editLevel;
    }

    public void setEditLevel(EditLevel editLevel) {
        this.editLevel = editLevel;
    }

    public EditMode getEditMode() {
        switch (this.modeState) {
            case 0: {
                return EditMode.NO_EDIT;
            }
            case 1: 
            case 3: {
                return EditMode.BLOCK;
            }
            case 2: 
            case 4: {
                return EditMode.PREVIEW;
            }
        }
        throw new IllegalStateException("Unexpected " + UIPortalApplication.class.getName() + ".modeState value " + this.modeState + ".");
    }

    public ComponentTab getComponentTab() {
        switch (this.modeState) {
            case 0: {
                return ComponentTab.NO_EDIT;
            }
            case 1: 
            case 2: {
                return ComponentTab.APPLICATIONS;
            }
            case 3: 
            case 4: {
                return ComponentTab.CONTAINERS;
            }
        }
        throw new IllegalStateException("Unexpected " + UIPortalApplication.class.getName() + ".modeState value " + this.modeState + ".");
    }

    public static enum EditLevel {
        NO_EDIT,
        EDIT_SITE,
        EDIT_PAGE;

    }

    public static enum ComponentTab {
        APPLICATIONS,
        CONTAINERS,
        NO_EDIT;

    }

    public static enum EditMode {
        BLOCK,
        PREVIEW,
        NO_EDIT;

    }
}

