/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.info;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.software.register.Utils;

@Path(value="/platform")
public class PlatformInformationRESTService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PlatformInformationRESTService.class);
    public static final String COMMUNITY_EDITION = "community";
    public static final String ENTERPRISE_EDITION = "enterprise";
    private ProductInformations platformInformations;
    private UserACL userACL;

    public PlatformInformationRESTService(ProductInformations productInformations, UserACL userACL) {
        this.platformInformations = productInformations;
        this.userACL = userACL;
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public Response getPlatformInformation(@Context SecurityContext sc) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            String plfProfile = ExoContainer.getProfiles().toString().trim();
            String runningProfile = plfProfile.substring(1, plfProfile.length() - 1);
            JsonPlatformInfo jsonPlatformInfo = new JsonPlatformInfo();
            jsonPlatformInfo.setPlatformVersion(this.platformInformations.getVersion());
            jsonPlatformInfo.setPlatformBuildNumber(this.platformInformations.getBuildNumber());
            jsonPlatformInfo.setPlatformRevision(this.platformInformations.getRevision());
            jsonPlatformInfo.setIsMobileCompliant(this.isMobileCompliant().toString());
            jsonPlatformInfo.setRunningProfile(runningProfile);
            jsonPlatformInfo.setPlatformEdition(this.getPlatformEdition());
            if (this.platformInformations.getEdition() != null && !this.platformInformations.getEdition().equals("")) {
                jsonPlatformInfo.setDuration(this.platformInformations.getDuration());
                jsonPlatformInfo.setDateOfKeyGeneration(this.platformInformations.getDateOfLicence());
                jsonPlatformInfo.setNbUsers(this.platformInformations.getNumberOfUsers());
                if (this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
                    jsonPlatformInfo.setProductCode(this.platformInformations.getProductCode());
                    jsonPlatformInfo.setUnlockKey(this.platformInformations.getProductKey());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting Platform Informations: eXo Platform (v" + this.platformInformations.getVersion() + " - build " + this.platformInformations.getBuildNumber() + " - rev. " + this.platformInformations.getRevision()));
            }
            return Response.ok((Object)jsonPlatformInfo, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting platform version information.", (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    public JsonPlatformInfo getJsonPlatformInfo() {
        try {
            String plfProfile = ExoContainer.getProfiles().toString().trim();
            String runningProfile = plfProfile.substring(1, plfProfile.length() - 1);
            JsonPlatformInfo jsonPlatformInfo = new JsonPlatformInfo();
            jsonPlatformInfo.setPlatformVersion(this.platformInformations.getVersion());
            jsonPlatformInfo.setPlatformBuildNumber(this.platformInformations.getBuildNumber());
            jsonPlatformInfo.setPlatformRevision(this.platformInformations.getRevision());
            jsonPlatformInfo.setIsMobileCompliant(this.isMobileCompliant().toString());
            jsonPlatformInfo.setRunningProfile(runningProfile);
            jsonPlatformInfo.setPlatformEdition(this.getPlatformEdition());
            if (this.platformInformations.getEdition() != null && !this.platformInformations.getEdition().equals("")) {
                jsonPlatformInfo.setDuration(this.platformInformations.getDuration());
                jsonPlatformInfo.setDateOfKeyGeneration(this.platformInformations.getDateOfLicence());
                jsonPlatformInfo.setNbUsers(this.platformInformations.getNumberOfUsers());
                jsonPlatformInfo.setProductCode(this.platformInformations.getProductCode());
                jsonPlatformInfo.setUnlockKey(this.platformInformations.getProductKey());
            } else {
                jsonPlatformInfo.setProductCode(Utils.readFromFile("ProductCode", Utils.HOME_CONFIG_FILE_LOCATION));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting Platform Informations: eXo Platform (v" + this.platformInformations.getVersion() + " - build " + this.platformInformations.getBuildNumber() + " - rev. " + this.platformInformations.getRevision()));
            }
            return jsonPlatformInfo;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while getting platform version information.", (Throwable)e);
            return null;
        }
    }

    private Boolean isMobileCompliant() {
        String platformEdition = this.getPlatformEdition();
        return platformEdition != null && (platformEdition.equals(COMMUNITY_EDITION) || platformEdition.equalsIgnoreCase("ENTERPRISE") || platformEdition.equals("EXPRESS"));
    }

    public String getPlatformEdition() {
        try {
            String platformEdition;
            String string = platformEdition = ExoContainer.hasProfile((String)COMMUNITY_EDITION) ? COMMUNITY_EDITION : ENTERPRISE_EDITION;
            if (StringUtils.isBlank((CharSequence)platformEdition) && this.platformInformations != null) {
                platformEdition = this.platformInformations.getEdition();
            }
            return platformEdition;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting the platform edition information.", (Throwable)e);
            return null;
        }
    }

    public static class JsonPlatformInfo {
        private String platformVersion;
        private String platformBuildNumber;
        private String platformRevision;
        private String platformEdition;
        private String isMobileCompliant;
        private String runningProfile;
        private String nbUsers;
        private String duration;
        private String buildNumber;
        private String productCode;
        private String dateOfKeyGeneration;
        private String unlockKey;

        public void setNbUsers(String nbUsers) {
            this.nbUsers = nbUsers;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public String getUnlockKey() {
            return this.unlockKey;
        }

        public void setUnlockKey(String unlockKey) {
            this.unlockKey = unlockKey;
        }

        public void setDateOfKeyGeneration(String dateOfKeyGeneration) {
            this.dateOfKeyGeneration = dateOfKeyGeneration;
        }

        public String getNbUsers() {
            return this.nbUsers;
        }

        public String getProductCode() {
            return this.productCode;
        }

        public String getDateOfKeyGeneration() {
            return this.dateOfKeyGeneration;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getPlatformVersion() {
            return this.platformVersion;
        }

        public void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public String getIsMobileCompliant() {
            return this.isMobileCompliant;
        }

        public void setIsMobileCompliant(String isMobileCompliant) {
            this.isMobileCompliant = isMobileCompliant;
        }

        public String getPlatformBuildNumber() {
            return this.platformBuildNumber;
        }

        public void setPlatformBuildNumber(String platformBuildNumber) {
            this.platformBuildNumber = platformBuildNumber;
        }

        public String getPlatformRevision() {
            return this.platformRevision;
        }

        public void setPlatformRevision(String platformRevision) {
            this.platformRevision = platformRevision;
        }

        public String getPlatformEdition() {
            return this.platformEdition;
        }

        public void setPlatformEdition(String platformEdition) {
            this.platformEdition = platformEdition;
        }

        public String getRunningProfile() {
            return this.runningProfile;
        }

        public void setRunningProfile(String runningProfile) {
            this.runningProfile = runningProfile;
        }
    }
}

