/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.service.plugin;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.service.MenuConfiguratorService;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MenuConfiguratorRemoveNodePlugin
extends BaseComponentPlugin {
    private MenuConfiguratorService menuConfiguratorService;
    private PageNode targetNode;
    private static final String TARGET_NODE = "node.config";
    private static final Log LOG = ExoLogger.getLogger(MenuConfiguratorRemoveNodePlugin.class);

    public MenuConfiguratorRemoveNodePlugin(MenuConfiguratorService menuConfiguratorService, InitParams initParams) {
        this.menuConfiguratorService = menuConfiguratorService;
        if (initParams.containsKey((Object)TARGET_NODE)) {
            this.targetNode = (PageNode)initParams.getObjectParam(TARGET_NODE).getObject();
        }
    }

    public void execute() {
        if (this.targetNode != null) {
            List<PageNode> setupPageNodes = this.menuConfiguratorService.getSetupMenuOriginalPageNodes();
            boolean isRemoved = this.removeTargetNode(this.targetNode, setupPageNodes);
            if (!isRemoved) {
                LOG.debug("Setup menu entry with name '{}' and page reference '{}' not found", new Object[]{this.targetNode.getName(), this.targetNode.getPageReference()});
            }
        } else {
            LOG.warn((Object)"No node removed : target node should be specified");
        }
    }

    private boolean removeTargetNode(PageNode targetNode, List<PageNode> setupPageNodes) {
        Iterator<PageNode> setupPagesIterator = setupPageNodes.iterator();
        boolean removed = false;
        while (setupPagesIterator.hasNext()) {
            PageNode pageNode = setupPagesIterator.next();
            if (!StringUtils.equals((CharSequence)pageNode.getName(), (CharSequence)targetNode.getName()) || !StringUtils.equals((CharSequence)pageNode.getPageReference(), (CharSequence)targetNode.getPageReference())) continue;
            setupPagesIterator.remove();
            removed = true;
            break;
        }
        return removed;
    }
}

