/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.portal.jdbc.entity.DescriptionState;

@Entity(name="GateInDescription")
@ExoEntity
@Table(name="PORTAL_DESCRIPTIONS")
@NamedQueries(value={@NamedQuery(name="DescriptionEntity.getByRefId", query="SELECT d FROM GateInDescription d WHERE d.referenceId = :refId")})
public class DescriptionEntity
implements Serializable {
    private static final long serialVersionUID = 1173817577220348267L;
    @Id
    @SequenceGenerator(name="SEQ_PORTAL_DESCRIPTIONS_ID", sequenceName="SEQ_PORTAL_DESCRIPTIONS_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_PORTAL_DESCRIPTIONS_ID")
    @Column(name="DESCRIPTION_ID")
    private Long id;
    @Column(name="REF_ID", length=200)
    private String referenceId;
    @Embedded
    private DescriptionState state;
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="PORTAL_DESCRIPTION_LOCALIZED", joinColumns={@JoinColumn(name="DESCRIPTION_ID")})
    @MapKeyColumn(name="LOCALE")
    private Map<String, DescriptionState> localized = new HashMap<String, DescriptionState>();

    public DescriptionEntity() {
    }

    public DescriptionEntity(String referenceId) {
        this.referenceId = referenceId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public DescriptionState getState() {
        return this.state;
    }

    public void setState(DescriptionState state) {
        this.state = state;
    }

    public Map<String, DescriptionState> getLocalized() {
        return this.localized;
    }

    public void setLocalized(Map<String, DescriptionState> localized) {
        this.localized = localized;
    }
}

