/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.metamodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import juzu.impl.common.JSON;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.request.Phase;

public class HandlerMetaModel
extends MetaModelObject {
    ControllerMetaModel controller;
    final ElementHandle.Method method;
    final String declaredId;
    final Phase phase;
    final String name;
    final ArrayList<ParameterMetaModel> parameters;
    final String id;

    HandlerMetaModel(ElementHandle.Method method, String declaredId, Phase phase, String name, ArrayList<ParameterMetaModel> parameters) {
        String id = declaredId == null ? method.getTypeName().getIdentifier() + "." + method.getName() : declaredId;
        this.method = method;
        this.declaredId = declaredId;
        this.phase = phase;
        this.name = name;
        this.parameters = parameters;
        this.id = id;
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.set("method", this.method);
        json.set("id", this.declaredId);
        json.set("phase", this.phase);
        json.set("name", this.name);
        json.map("parameters", new ArrayList<ParameterMetaModel>(this.parameters));
        return json;
    }

    public ControllerMetaModel getController() {
        return this.controller;
    }

    public ElementHandle.Method getMethod() {
        return this.method;
    }

    public String getId() {
        return this.id;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<ParameterMetaModel> getParameters() {
        return this.parameters;
    }

    public ParameterMetaModel parameterAt(int index) {
        return this.parameters.get(index);
    }

    public ParameterMetaModel parameterBy(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null name allowed");
        }
        for (ParameterMetaModel parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public Set<String> getParameterNames() {
        HashSet<String> tmp = new HashSet<String>();
        for (ParameterMetaModel param : this.parameters) {
            tmp.add(param.getName());
        }
        return tmp;
    }

    @Override
    protected void preDetach(MetaModelObject parent) {
        this.queue(MetaModelEvent.createRemoved(this, this.controller.getControllers().getApplication().getHandle()));
        this.controller = null;
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        this.controller = (ControllerMetaModel)parent;
        this.queue(MetaModelEvent.createAdded(this));
    }
}

