/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.ActivityFileStoragePlugin;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class RDBMSActivityFileStoragePlugin
extends ActivityFileStoragePlugin {
    private static final String FILE_API_NAMESPACE = "social";
    private FileService fileService;
    private UploadService uploadService;

    public RDBMSActivityFileStoragePlugin(FileService fileService, UploadService uploadService, InitParams initParams) {
        super(initParams);
        this.fileService = fileService;
        this.uploadService = uploadService;
    }

    @Override
    public void storeAttachments(ExoSocialActivity activity, Identity streamOwner, ActivityFile ... attachments) throws Exception {
        if (attachments == null || attachments.length == 0) {
            return;
        }
        for (ActivityFile activityFile : attachments) {
            UploadResource uploadedResource = this.uploadService.getUploadResource(activityFile.getUploadId());
            if (uploadedResource == null) {
                throw new IllegalStateException("Cannot attach uploaded file " + activityFile.getUploadId() + ", it may not exist");
            }
            FileItem fileItem = null;
            String fileDiskLocation = uploadedResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                fileItem = this.fileService.writeFile(new FileItem(null, uploadedResource.getFileName(), uploadedResource.getMimeType(), FILE_API_NAMESPACE, Double.doubleToLongBits(uploadedResource.getUploadedSize()), new Date(), activity.getPosterId(), false, (InputStream)inputStream));
            }
            if (fileItem != null) {
                if (activity.getTemplateParams() == null) {
                    activity.setTemplateParams(new HashMap<String, String>());
                }
                this.concatenateParam(activity.getTemplateParams(), "storage", this.getDatasourceName());
                this.concatenateParam(activity.getTemplateParams(), "id", String.valueOf(fileItem.getFileInfo().getId()));
            }
            this.uploadService.removeUploadResource(activityFile.getUploadId());
        }
    }
}

