/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class LinkProvider {
    public static final String RESOURCE_URL = "/social-resources";
    public static final String JAVASCRIPT_RESOURCE_URL = "/social-resources/javascript/";
    public static final String PROFILE_DEFAULT_AVATAR_URL = "/eXoSkin/skin/images/system/UserAvtDefault.png";
    public static final String SPACE_DEFAULT_AVATAR_URL = "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
    public static final String HAS_CONNECTION_ICON = "/social-resources/eXoSkin/skin/images/themes/default/social/skin/UIManageUsers/StatusIcon.png";
    public static final String WAITING_CONFIRMATION_ICON = "/social-resources/eXoSkin/skin/images/themes/default/social/skin/UIManageUsers/WaittingConfirm.png";
    public static final String SPACE_MANAGER_ICON = "/social-resources/eXoSkin/skin/images/themes/default/social/skin/UIManageSpaces/Manager.png";
    public static final String SPACE_MEMBER_ICON = "/social-resources/eXoSkin/skin/images/themes/default/social/skin/UIManageSpaces/Member.png";
    public static final String SPACE_WAITING_CONFIRM_ICON = "/social-resources/eXoSkin/skin/images/themes/default/social/skin/UIManageSpaces/WaitingConfirm.png";
    public static final String STARTER_ACTIVITY_AVATAR = "/eXoSkin/skin/images/themes/default/social/skin/Activity/starterAvt.png";
    public static final String STARTER_ACTIVITY_IMAGE = "/eXoSkin/skin/images/themes/default/social/skin/Activity/starterActImg.png";
    public static final String ROUTE_DELIMITER = "/";
    private static Log LOG = ExoLogger.getLogger(LinkProvider.class);
    private static final String BASE_URL_SOCIAL_REST_API = "/v1/social";

    public static String getSpaceUri(String prettyName) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceByPrettyName(prettyName);
        RequestContext ctx = RequestContext.getCurrentInstance();
        if (ctx != null && space != null) {
            NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
            NavigationResource resource = new NavigationResource(SiteType.GROUP, space.getGroupId(), space.getUrl());
            return nodeURL.setResource(resource).toString();
        }
        return null;
    }

    public static String getProfileUri(String username) {
        return LinkProvider.buildProfileUri(username, null, null);
    }

    public static String getProfileUri(String username, String portalOwner) {
        return LinkProvider.buildProfileUri(username, null, portalOwner);
    }

    public static String getProfileLink(String username) {
        return LinkProvider.getProfileLink(username, null);
    }

    public static String getProfileLink(String username, String portalOwner) {
        Identity identity = LinkProvider.getIdentityManager().getOrCreateIdentity("organization", username, true);
        Validate.notNull((Object)identity, (String)"Identity must not be null.");
        String configured_domain_url = null;
        try {
            configured_domain_url = CommonsUtils.getCurrentDomain();
        }
        catch (NullPointerException e) {
            configured_domain_url = null;
        }
        return "<a href=\"" + (configured_domain_url != null ? configured_domain_url : "") + LinkProvider.buildProfileUri(identity.getRemoteId(), null, portalOwner) + "\" target=\"_parent\">" + StringEscapeUtils.escapeHtml((String)identity.getProfile().getFullName()) + "</a>";
    }

    public static String getAbsoluteProfileUrl(String userName, String portalName, String portalOwner, String host) {
        return host + LinkProvider.buildProfileUri(userName, portalName, portalOwner);
    }

    public static String getUserActivityUri(String remoteId) {
        return LinkProvider.getActivityUri("organization", remoteId);
    }

    public static String getUserConnectionsUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/connections/all-people" + ROUTE_DELIMITER + remoteId;
    }

    public static String getUserConnectionsYoursUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/connections/network" + ROUTE_DELIMITER + remoteId;
    }

    public static String getUserProfileUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/profile" + ROUTE_DELIMITER + remoteId;
    }

    public static String getActivityUri(String providerId, String remoteId) {
        String prefix = LinkProvider.getBaseUri(null, null) + ROUTE_DELIMITER;
        if (providerId.equals("organization")) {
            return String.format("%sactivities/%s", prefix, remoteId);
        }
        if (providerId.equals("space")) {
            return String.format("/%s/g/:spaces:%s/%s", LinkProvider.getPortalName(null), remoteId, remoteId);
        }
        LOG.warn((Object)("Failed to getActivityLink with providerId: " + providerId));
        return null;
    }

    public static String getSingleActivityUrl(String activityId) {
        return LinkProvider.getBaseUri(null, null) + "/activity?id=" + activityId;
    }

    public static String getActivityUriForSpace(String remoteId, String groupId) {
        return String.format("/%s/g/:spaces:%s/%s", LinkProvider.getPortalName(null), groupId, remoteId);
    }

    private static String buildProfileUri(String userName, String portalName, String portalOwner) {
        return LinkProvider.getBaseUri(portalName, portalOwner) + "/profile" + ROUTE_DELIMITER + userName;
    }

    private static String getBaseUri(String portalName, String portalOwner) {
        return ROUTE_DELIMITER + LinkProvider.getPortalName(portalName) + ROUTE_DELIMITER + LinkProvider.getPortalOwner(portalOwner);
    }

    private static String getSpaceBaseUri(String portalName, String portalOwner) {
        return ROUTE_DELIMITER + LinkProvider.getPortalName(portalName);
    }

    public static String getUserNotificationSettingUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/notifications" + ROUTE_DELIMITER + remoteId;
    }

    public static String getRedirectUri(String type) {
        if (type.isEmpty()) {
            return LinkProvider.getBaseUri(null, null);
        }
        return LinkProvider.getBaseUri(null, null) + ROUTE_DELIMITER + type;
    }

    public static String getRedirectSpaceUri(String type) {
        if (type.isEmpty()) {
            return LinkProvider.getSpaceBaseUri(null, null);
        }
        return LinkProvider.getSpaceBaseUri(null, null) + ROUTE_DELIMITER + type;
    }

    public static IdentityManager getIdentityManager() {
        return (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    }

    public static String buildAvatarURL(String providerId, String remoteId) {
        return LinkProvider.buildAttachmentUrl(providerId, remoteId, "avatar");
    }

    public static String buildBannerURL(String providerId, String remoteId) {
        return LinkProvider.buildAttachmentUrl(providerId, remoteId, "banner");
    }

    private static String buildAttachmentUrl(String providerId, String remoteId, String type) {
        if (providerId == null || remoteId == null) {
            return null;
        }
        String username = remoteId;
        try {
            username = URLEncoder.encode(username, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn((Object)"Failure to encode username for build URL", (Throwable)ex);
        }
        if (providerId.equals("organization")) {
            return ROUTE_DELIMITER + CommonsUtils.getRestContextName() + BASE_URL_SOCIAL_REST_API + "/users" + ROUTE_DELIMITER + username + ROUTE_DELIMITER + type;
        }
        if (providerId.equals("space")) {
            return ROUTE_DELIMITER + CommonsUtils.getRestContextName() + BASE_URL_SOCIAL_REST_API + "/spaces" + ROUTE_DELIMITER + username + ROUTE_DELIMITER + type;
        }
        return null;
    }

    private static String getPortalOwner(String portalOwner) {
        if (portalOwner == null || portalOwner.trim().length() == 0) {
            portalOwner = CommonsUtils.getCurrentPortalOwner();
        }
        return portalOwner;
    }

    private static String getPortalName(String portalName) {
        if (portalName == null || portalName.trim().length() == 0) {
            return PortalContainer.getCurrentPortalContainerName();
        }
        return portalName;
    }
}

