/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceTemplateStatisticsListenerPlugin
extends SpaceListenerPlugin {
    private static final String FORMAT_CREATION = "local_service={} operation={} parameters=\"date:{},space_name:{},space_id:{},user_social_id:{},template_name:{}\"";
    private static final String FORMAT_MODIFICATION = "local_service={} operation={} parameters=\"date:{},space_name:{},space_id:{},user_social_id:{},template_name:{},modification_type:{}\"";
    private static final String FORMAT_APPLICATION = "local_service={} operation={} parameters=\"date:{},space_name:{},space_id:{},user_social_id:{},template_name:{},modification_type:{},application_id:{}\"";
    private static final String SPACE_TEMPLATES_SERVICE = "space_templates";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String CREATE_SPACE_OPERATION = "create_space";
    private static final String MODIFY_SPACE_OPERATION = "modify_space";
    private static final Log LOG = ExoLogger.getExoLogger(SpaceTemplateStatisticsListenerPlugin.class);
    private IdentityManager identityManager;

    public SpaceTemplateStatisticsListenerPlugin(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @Override
    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceName = space.getPrettyName();
        String spaceId = space.getId();
        String creator = space.getManagers()[0];
        Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
        String creatorId = creatorIdentity.getId();
        String templateName = space.getTemplate();
        String dateString = DATE_FORMAT.format(new Date());
        LOG.info(FORMAT_CREATION, new Object[]{SPACE_TEMPLATES_SERVICE, CREATE_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName});
    }

    @Override
    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    @Override
    public void applicationAdded(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        String appId = event.getTarget();
        if (spaceId != null) {
            String spaceName = space.getPrettyName();
            String creator = space.getManagers()[0];
            Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
            String creatorId = creatorIdentity.getId();
            String templateName = space.getTemplate();
            String dateString = DATE_FORMAT.format(new Date());
            LOG.info(FORMAT_APPLICATION, new Object[]{SPACE_TEMPLATES_SERVICE, MODIFY_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName, "application_added", appId});
        }
    }

    @Override
    public void applicationRemoved(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        String appId = event.getTarget();
        if (spaceId != null) {
            String spaceName = space.getPrettyName();
            String creator = space.getManagers()[0];
            Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
            String creatorId = creatorIdentity.getId();
            String templateName = space.getTemplate();
            String dateString = DATE_FORMAT.format(new Date());
            LOG.info(FORMAT_APPLICATION, new Object[]{SPACE_TEMPLATES_SERVICE, MODIFY_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName, "application_removed", appId});
        }
    }

    @Override
    public void applicationActivated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        String appId = event.getTarget();
        if (spaceId != null) {
            String spaceName = space.getPrettyName();
            String creator = space.getManagers()[0];
            Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
            String creatorId = creatorIdentity.getId();
            String templateName = space.getTemplate();
            String dateString = DATE_FORMAT.format(new Date());
            LOG.info(FORMAT_APPLICATION, new Object[]{SPACE_TEMPLATES_SERVICE, MODIFY_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName, "application_activated", appId});
        }
    }

    @Override
    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        String appId = event.getTarget();
        if (spaceId != null) {
            String spaceName = space.getPrettyName();
            String creator = space.getManagers()[0];
            Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
            String creatorId = creatorIdentity.getId();
            String templateName = space.getTemplate();
            String dateString = DATE_FORMAT.format(new Date());
            LOG.info(FORMAT_APPLICATION, new Object[]{SPACE_TEMPLATES_SERVICE, MODIFY_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName, "application_deactivated", appId});
        }
    }

    @Override
    public void joined(SpaceLifeCycleEvent event) {
    }

    @Override
    public void left(SpaceLifeCycleEvent event) {
    }

    @Override
    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    @Override
    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    @Override
    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    @Override
    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    @Override
    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    @Override
    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        if (spaceId != null) {
            String spaceName = space.getPrettyName();
            String creator = space.getManagers()[0];
            Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
            String creatorId = creatorIdentity.getId();
            String templateName = space.getTemplate();
            String dateString = DATE_FORMAT.format(new Date());
            LOG.info(FORMAT_MODIFICATION, new Object[]{SPACE_TEMPLATES_SERVICE, MODIFY_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName, "visibility"});
        }
    }

    @Override
    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    @Override
    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    @Override
    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        if (spaceId != null) {
            String spaceName = space.getPrettyName();
            String creator = space.getManagers()[0];
            Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
            String creatorId = creatorIdentity.getId();
            String templateName = space.getTemplate();
            String dateString = DATE_FORMAT.format(new Date());
            LOG.info(FORMAT_MODIFICATION, new Object[]{SPACE_TEMPLATES_SERVICE, MODIFY_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName, "registration"});
        }
    }

    @Override
    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        if (spaceId != null && event.getSource() != null) {
            String spaceName = space.getPrettyName();
            String creator = space.getManagers()[0];
            Identity creatorIdentity = this.identityManager.getOrCreateIdentity("organization", creator, true);
            String creatorId = creatorIdentity.getId();
            String templateName = space.getTemplate();
            String dateString = DATE_FORMAT.format(new Date());
            LOG.info(FORMAT_MODIFICATION, new Object[]{SPACE_TEMPLATES_SERVICE, MODIFY_SPACE_OPERATION, dateString, spaceName, spaceId, creatorId, templateName, "banner"});
        }
    }
}

