/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.exoplatform.commons.cache.future.Loader;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public abstract class FutureCache<K, V, C> {
    private final Loader<K, V, C> loader;
    private final ConcurrentMap<K, FutureTask<V>> futureEntries;
    private final Logger log = LoggerFactory.getLogger(FutureCache.class);

    public FutureCache(Loader<K, V, C> loader) {
        this.loader = loader;
        this.futureEntries = new ConcurrentHashMap<K, FutureTask<V>>();
    }

    protected abstract V get(K var1);

    protected abstract void put(K var1, V var2);

    protected abstract void putOnly(K var1, V var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(final C context, final K key) {
        V value = this.get(key);
        if (value == null) {
            FutureTask future = new FutureTask(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    Object value = FutureCache.this.loader.retrieve(context, key);
                    if (value != null) {
                        FutureCache.this.putOnly(key, value);
                        return value;
                    }
                    return null;
                }
            });
            boolean inserted = true;
            try {
                FutureTask phantom = this.futureEntries.putIfAbsent(key, future);
                if (phantom != null) {
                    future = phantom;
                    inserted = false;
                } else {
                    future.run();
                }
                value = future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw new UndeclaredThrowableException(e.getCause());
                }
                this.log.error((Object)("Computing of resource " + key + " threw an exception"), e.getCause());
            }
            catch (Exception e) {
                this.log.error((Object)("Retrieval of resource " + key + " threw an exception"), (Throwable)e);
            }
            finally {
                if (inserted) {
                    this.futureEntries.remove(key, future);
                }
            }
        }
        return value;
    }
}

