/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.SecurityHelper;

public class AnnotationIntrospector {
    public static <A extends Annotation> A resolveClassAnnotations(Class<?> clazz, Class<A> classAnnotation) throws IllegalArgumentException {
        Class<?> superClazz;
        if (clazz == null) {
            throw new IllegalArgumentException("No null class");
        }
        if (classAnnotation == null) {
            throw new IllegalArgumentException("No null annotation");
        }
        A tpl = clazz.getAnnotation(classAnnotation);
        if (tpl == null) {
            Class<?> itf;
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (tpl = AnnotationIntrospector.resolveClassAnnotations(itf = classArray[i], classAnnotation)) == null; ++i) {
            }
        }
        if (tpl == null && (superClazz = clazz.getSuperclass()) != null) {
            tpl = AnnotationIntrospector.resolveClassAnnotations(superClazz, classAnnotation);
        }
        return tpl;
    }

    public static <A extends Annotation> Map<Method, A> resolveMethodAnnotations(final Class<?> clazz, Class<A> methodAnnotation) {
        if (clazz == null) {
            throw new IllegalArgumentException("No null class");
        }
        if (methodAnnotation == null) {
            throw new IllegalArgumentException("No null annotation");
        }
        HashMap<Method, A> methods = new HashMap<Method, A>();
        PrivilegedAction<Method[]> action = new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        };
        for (Method method : SecurityHelper.doPrivilegedAction(action)) {
            A annotation = method.getAnnotation(methodAnnotation);
            if (annotation == null) continue;
            methods.put(method, annotation);
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            Map<Method, A> parentAnnotations = AnnotationIntrospector.resolveMethodAnnotations(superClazz, methodAnnotation);
            for (Map.Entry<Method, A> entry : parentAnnotations.entrySet()) {
                Method parentMethod = entry.getKey();
                try {
                    Method method = clazz.getMethod(parentMethod.getName(), parentMethod.getParameterTypes());
                    if (methods.containsKey(method)) continue;
                    methods.put(method, entry.getValue());
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        for (Class<?> itf : clazz.getInterfaces()) {
            Map<Method, A> itfAnnotations = AnnotationIntrospector.resolveMethodAnnotations(itf, methodAnnotation);
            for (Map.Entry<Method, A> entry : itfAnnotations.entrySet()) {
                Method itfMethod = entry.getKey();
                try {
                    Method method = clazz.getMethod(itfMethod.getName(), itfMethod.getParameterTypes());
                    if (methods.containsKey(method)) continue;
                    methods.put(method, entry.getValue());
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return methods;
    }
}

