/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType2
extends PDFunction {
    private COSArray C0;
    private COSArray C1;
    private Float N;

    public PDFunctionType2(COSBase function) {
        super(function);
    }

    public int getFunctionType() {
        return 2;
    }

    public float[] eval(float[] input) throws IOException {
        double inputValue = input[0];
        double exponent = this.getN();
        COSArray c0 = this.getC0();
        COSArray c1 = this.getC1();
        int c0Size = c0.size();
        float[] functionResult = new float[c0Size];
        for (int j = 0; j < c0Size; ++j) {
            functionResult[j] = ((COSNumber)c0.get(j)).floatValue() + (float)Math.pow(inputValue, exponent) * (((COSNumber)c1.get(j)).floatValue() - ((COSNumber)c0.get(j)).floatValue());
        }
        return this.clipToRange(functionResult);
    }

    public COSArray getC0() {
        if (this.C0 == null) {
            this.C0 = (COSArray)this.getDictionary().getDictionaryObject(COSName.C0);
            if (this.C0 == null) {
                this.C0 = new COSArray();
                this.C0.add(new COSFloat(0.0f));
            }
        }
        return this.C0;
    }

    public COSArray getC1() {
        if (this.C1 == null) {
            this.C1 = (COSArray)this.getDictionary().getDictionaryObject(COSName.C1);
            if (this.C1 == null) {
                this.C1 = new COSArray();
                this.C1.add(new COSFloat(1.0f));
            }
        }
        return this.C1;
    }

    public float getN() {
        if (this.N == null) {
            this.N = Float.valueOf(this.getDictionary().getFloat(COSName.N));
        }
        return this.N.floatValue();
    }
}

