/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.io.Serializable;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

public class BooleanStaticAssertionPredicate
extends AbstractSimplePredicate
implements Serializable {
    private final Boolean assertedValue;

    public BooleanStaticAssertionPredicate(CriteriaBuilderImpl criteriaBuilder, Boolean assertedValue) {
        super(criteriaBuilder);
        this.assertedValue = assertedValue;
    }

    public Boolean getAssertedValue() {
        return this.assertedValue;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        boolean isTrue = this.getAssertedValue();
        if (this.isNegated()) {
            isTrue = !isTrue;
        }
        return isTrue ? "1=1" : "0=1";
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

