/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.search.GroupSearchService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="v1/groups")
public class GroupRestResourcesV1
implements ResourceContainer {
    public static final int DEFAULT_LIMIT = 20;
    public static final int DEFAULT_OFFSET = 0;
    private GroupSearchService groupSearchService;

    public GroupRestResourcesV1(GroupSearchService groupSearchService) {
        this.groupSearchService = groupSearchService;
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Gets groups", httpMethod="GET", response=Response.class, notes="This returns the list of groups containing the given search text, only if the authenticated user is a spaces administrator")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=500, message="Internal server error")})
    public Response getGroups(@Context UriInfo uriInfo, @ApiParam(value="Search text to filter groups") @QueryParam(value="q") String q, @ApiParam(value="Offset") @QueryParam(value="offset") int offset, @ApiParam(value="Limit") @QueryParam(value="limit") int limit, @QueryParam(value="returnSize") boolean returnSize, @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : 0;
        limit = limit > 0 ? limit : 20;
        int size = this.groupSearchService.searchGroups(q).getSize();
        limit = limit < size ? limit : size;
        Group[] groups = (Group[])this.groupSearchService.searchGroups(q).load(offset, limit);
        LinkedList<Group> listAllGroups = new LinkedList<Group>(Arrays.asList(groups));
        return Response.ok(listAllGroups, (String)"application/json").build();
    }
}

