/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.provider.IOHelper;
import org.exoplatform.services.rest.impl.provider.JsonEntityProvider;

@Provider
@Produces(value={"application/javascript", "text/javascript", "application/json-p", "text/json-p"})
public class JsonpEntityProvider
extends JsonEntityProvider {
    private static final String JSONP_PARAMETER = "jsonp";

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return false;
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        if (context == null) {
            throw new IOException("Cannot get the jsonp parameter, the context is null");
        }
        String callback = (String)context.getQueryParameters().getFirst((Object)JSONP_PARAMETER);
        if (callback == null) {
            throw new IOException("The parameter 'jsonp' has not been set");
        }
        StringBuilder result = new StringBuilder();
        result.append(callback).append('(');
        String charset = (String)mediaType.getParameters().get("charset");
        if (t instanceof String) {
            result.append(t);
            result.append(");");
            IOHelper.writeString(result.toString(), entityStream, charset);
        } else {
            IOHelper.writeString(result.toString(), entityStream, charset);
            super.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
            IOHelper.writeString(");", entityStream, charset);
        }
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(type, genericType, annotations, mediaType) || String.class.isAssignableFrom(type);
    }
}

