/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SpaceMemberFilterListAccess
implements ListAccess<Identity> {
    private IdentityStorage identityStorage;
    Space space;
    Type type = Type.MEMBER;
    String providerId;
    ProfileFilter profileFilter;

    public SpaceMemberFilterListAccess(IdentityStorage identityStorage, Space space, ProfileFilter filter) {
        this.identityStorage = identityStorage;
        this.profileFilter = filter;
        this.space = space;
    }

    public SpaceMemberFilterListAccess(IdentityStorage identityStorage, Space space, ProfileFilter filter, Type type) {
        this(identityStorage, space, filter);
        this.type = type;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        IdentityManager manager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        if (this.profileFilter.isSortingEmpty()) {
            this.profileFilter.setSorting(manager.getDefaultSorting());
        }
        if (StringUtils.isBlank((CharSequence)this.profileFilter.getFirstCharFieldName())) {
            this.profileFilter.setFirstCharFieldName(manager.getFirstCharacterFiltering());
        }
        List<Identity> identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(this.space, this.profileFilter, this.type, offset, limit);
        return identities.toArray(new Identity[identities.size()]);
    }

    public int getSize() throws Exception {
        return this.identityStorage.countSpaceMemberIdentitiesByProfileFilter(this.space, this.profileFilter, this.type);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        MEMBER,
        MANAGER;

    }
}

