/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderProcessor;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;
import org.gatein.security.oauth.spi.SocialNetworkService;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public abstract class OAuthProviderFilter<T extends AccessTokenContext>
extends AbstractSSOInterceptor {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AuthenticationRegistry authenticationRegistry;
    private OAuthProviderProcessor<T> oauthProviderProcessor;
    private OAuthProviderTypeRegistry oAuthProviderTypeRegistry;
    private SocialNetworkService socialNetworkService;
    protected String providerKey;

    protected void initImpl() {
        this.providerKey = this.getInitParameter("providerKey");
        this.authenticationRegistry = (AuthenticationRegistry)this.getExoContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
        this.oAuthProviderTypeRegistry = (OAuthProviderTypeRegistry)this.getExoContainer().getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
        this.socialNetworkService = (SocialNetworkService)this.getExoContainer().getComponentInstanceOfType(SocialNetworkService.class);
        this.oauthProviderProcessor = this.getOAuthProvider().getOauthProviderProcessor();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        OAuthPrincipal<T> oauthPrincipal;
        InteractionState interactionState;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession();
        String interaction = httpRequest.getParameter("_oauthInteraction");
        if ("start".equals(interaction)) {
            this.initInteraction(httpRequest, httpResponse);
            this.saveRememberMe(httpRequest);
            this.saveInitialURI(httpRequest);
            this.authenticationRegistry.removeAttributeOfClient(httpRequest, "_authenticatedPortalUser");
        }
        String scopeToUse = this.obtainCustomScopeIfAvailable(httpRequest);
        try {
            if (scopeToUse == null) {
                interactionState = this.getOauthProviderProcessor().processOAuthInteraction(httpRequest, httpResponse);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Process oauth interaction with scope: " + scopeToUse));
                }
                interactionState = this.getOauthProviderProcessor().processOAuthInteraction(httpRequest, httpResponse, scopeToUse);
            }
        }
        catch (OAuthException ex) {
            this.log.warn((Object)("Error during OAuth flow with: " + ex.getMessage()));
            session.setAttribute("_oauthException", (Object)ex);
            this.redirectAfterOAuthError(httpRequest, httpResponse);
            return;
        }
        if (InteractionState.State.FINISH.equals((Object)interactionState.getState()) && (oauthPrincipal = this.getOAuthPrincipal(httpRequest, httpResponse, interactionState)) != null) {
            if (httpRequest.getRemoteUser() == null) {
                this.authenticationRegistry.setAttributeOfClient(httpRequest, "_authenticatedOAuthPrincipal", oauthPrincipal);
            } else {
                httpRequest.setAttribute("_authenticatedOAuthPrincipal", oauthPrincipal);
            }
            chain.doFilter(request, response);
        }
    }

    protected AuthenticationRegistry getAuthenticationRegistry() {
        return this.authenticationRegistry;
    }

    protected OAuthProviderProcessor<T> getOauthProviderProcessor() {
        return this.oauthProviderProcessor;
    }

    protected OAuthProviderTypeRegistry getOAuthProviderTypeRegistry() {
        return this.oAuthProviderTypeRegistry;
    }

    protected SocialNetworkService getSocialNetworkService() {
        return this.socialNetworkService;
    }

    protected String obtainCustomScopeIfAvailable(HttpServletRequest httpRequest) {
        String customScope = httpRequest.getParameter("_oauthCustomScope");
        if (customScope != null) {
            String currentUser = httpRequest.getRemoteUser();
            if (currentUser == null) {
                this.log.warn((Object)"Parameter _oauthCustomScope found but there is no user available. Ignoring it.");
                return null;
            }
            AccessTokenContext currentAccessToken = this.socialNetworkService.getOAuthAccessToken(this.getOAuthProvider(), currentUser);
            if (currentAccessToken != null) {
                currentAccessToken.addScope(customScope);
                return currentAccessToken.getScopesAsString();
            }
            return customScope;
        }
        return null;
    }

    protected void redirectAfterOAuthError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String urlToRedirect = OAuthUtils.getURLToRedirectAfterLinkAccount((HttpServletRequest)request, (HttpSession)session);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Will redirect user to URL: " + urlToRedirect));
        }
        response.sendRedirect(response.encodeRedirectURL(urlToRedirect));
    }

    protected void saveInitialURI(HttpServletRequest request) {
        String initialURI = request.getParameter("_initialURI");
        if (initialURI != null) {
            request.getSession().setAttribute("_urlToRedirectAfterLinkSocialAccount", (Object)initialURI);
        }
    }

    protected void saveRememberMe(HttpServletRequest request) {
        String rememberMe = request.getParameter("_rememberme");
        request.getSession().setAttribute("_rememberme", (Object)rememberMe);
    }

    protected <T extends AccessTokenContext> OAuthProviderType<T> getOauthProvider(String defaultKey, Class<T> c) {
        String key = this.providerKey != null ? this.providerKey : defaultKey;
        return this.getOAuthProviderTypeRegistry().getOAuthProvider(key, c);
    }

    protected abstract OAuthProviderType<T> getOAuthProvider();

    protected abstract void initInteraction(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract OAuthPrincipal<T> getOAuthPrincipal(HttpServletRequest var1, HttpServletResponse var2, InteractionState<T> var3);
}

