/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.util.Joiner;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationRequestUrl
extends GenericUrl {
    @Key(value="response_type")
    private String responseTypes;
    @Key(value="redirect_uri")
    private String redirectUri;
    @Key(value="scope")
    private String scopes;
    @Key(value="client_id")
    private String clientId;
    @Key
    private String state;

    public AuthorizationRequestUrl(String authorizationServerEncodedUrl, String clientId, Iterable<String> responseTypes) {
        super(authorizationServerEncodedUrl);
        Preconditions.checkArgument((this.getFragment() == null ? 1 : 0) != 0);
        this.setClientId(clientId);
        this.setResponseTypes(responseTypes);
    }

    public final String getResponseTypes() {
        return this.responseTypes;
    }

    public AuthorizationRequestUrl setResponseTypes(String ... responseTypes) {
        return this.setResponseTypes(Arrays.asList(responseTypes));
    }

    public AuthorizationRequestUrl setResponseTypes(Iterable<String> responseTypes) {
        this.responseTypes = Joiner.on((char)' ').join(responseTypes);
        return this;
    }

    public final String getRedirectUri() {
        return this.redirectUri;
    }

    public AuthorizationRequestUrl setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public final String getScopes() {
        return this.scopes;
    }

    public AuthorizationRequestUrl setScopes(String ... scopes) {
        return this.setScopes(scopes == null ? null : Arrays.asList(scopes));
    }

    public AuthorizationRequestUrl setScopes(Iterable<String> scopes) {
        this.scopes = scopes == null ? null : Joiner.on((char)' ').join(scopes);
        return this;
    }

    public final String getClientId() {
        return this.clientId;
    }

    public AuthorizationRequestUrl setClientId(String clientId) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId);
        return this;
    }

    public final String getState() {
        return this.state;
    }

    public AuthorizationRequestUrl setState(String state) {
        this.state = state;
        return this;
    }

    public AuthorizationRequestUrl set(String fieldName, Object value) {
        return (AuthorizationRequestUrl)super.set(fieldName, value);
    }

    public AuthorizationRequestUrl clone() {
        return (AuthorizationRequestUrl)super.clone();
    }
}

