/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;

public abstract class ActivityFileStoragePlugin
extends BaseComponentPlugin {
    public static final String ACTIVITY_FILE_STORAGE_PARAM_NAME = "storage";
    public static final String ACTIVITY_FILE_ID_PARAM_NAME = "id";
    public static final String TEMPLATE_PARAMS_SEPARATOR = "|@|";
    protected String datasourceName;
    protected int priority;

    public ActivityFileStoragePlugin(InitParams initParams) {
        if (initParams == null) {
            throw new IllegalStateException("Init param 'datasource' is mandatory");
        }
        if (!initParams.containsKey((Object)"datasource")) {
            throw new IllegalStateException("Init param 'datasource' is mandatory");
        }
        this.datasourceName = initParams.getValueParam("datasource").getValue();
        if (initParams.containsKey((Object)"priority")) {
            String priorityString = initParams.getValueParam("priority").getValue();
            this.priority = Integer.parseInt(priorityString);
        }
    }

    public abstract void storeAttachments(ExoSocialActivity var1, Identity var2, ActivityFile ... var3) throws Exception;

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    protected void concatenateParam(Map<String, String> activityParams, String paramName, String paramValue) {
        String oldParamValue = activityParams.get(paramName);
        if (StringUtils.isBlank((CharSequence)oldParamValue)) {
            activityParams.put(paramName, paramValue);
        } else {
            activityParams.put(paramName, oldParamValue + TEMPLATE_PARAMS_SEPARATOR + paramValue);
        }
    }

    protected List<String> readParamValues(Map<String, String> activityParams, String paramName) {
        String paramValue = activityParams.get(paramName);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return Collections.emptyList();
        }
        return Arrays.asList(paramValue.split(TEMPLATE_PARAMS_SEPARATOR));
    }
}

