/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.appcenter.entity.ApplicationEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ApplicationDAO
extends GenericDAOJPAImpl<ApplicationEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(ApplicationDAO.class);

    public List<ApplicationEntity> getFavoriteActiveApps(String userName) {
        return this.getEntityManager().createNamedQuery("ApplicationEntity.getFavoriteActiveApps", ApplicationEntity.class).setParameter("userName", (Object)userName).getResultList();
    }

    public List<ApplicationEntity> getApplications(String keyword, int offset, int limit) {
        TypedQuery query = null;
        if (StringUtils.isBlank((String)keyword)) {
            query = this.getEntityManager().createNamedQuery("ApplicationEntity.getApplications", ApplicationEntity.class);
        } else {
            query = this.getEntityManager().createNamedQuery("ApplicationEntity.getApplicationsByKeyword", ApplicationEntity.class);
            keyword = "%" + keyword.replaceAll("%", "").replaceAll("\\*", "%") + "%";
            query.setParameter("title", (Object)keyword);
            query.setParameter("url", (Object)keyword);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<ApplicationEntity> getSystemApplications() {
        TypedQuery query = this.getEntityManager().createNamedQuery("ApplicationEntity.getSystemApplications", ApplicationEntity.class);
        return query.getResultList();
    }

    public ApplicationEntity getApplicationByTitleOrUrl(String title, String url) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ApplicationEntity.getAppByTitleOrUrl", ApplicationEntity.class).setParameter("title", (Object)title).setParameter("url", (Object)url);
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            LOG.warn("More than one application was found with URL '{}' or Title '{}'", new Object[]{url, title});
            return (ApplicationEntity)result.get(0);
        }
        return (ApplicationEntity)result.get(0);
    }
}

