/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.DynamicPortalLayoutMatcherPlugin;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class DynamicPortalLayoutService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(DynamicPortalLayoutService.class);
    private ConfigurationManager configurationManager;
    private DataStorage dataStorage;
    private boolean forceIgnoreStoredLayout;
    private Map<String, DynamicPortalLayoutMatcherPlugin> dynamicLayoutMatcherPlugins = new LinkedHashMap<String, DynamicPortalLayoutMatcherPlugin>();

    public DynamicPortalLayoutService(ConfigurationManager configurationManager, DataStorage dataStorage, InitParams params) {
        this.dataStorage = dataStorage;
        this.configurationManager = configurationManager;
        ValueParam ignoreStoredLayoutParam = params.getValueParam("forceIgnoreStoredLayout");
        if (ignoreStoredLayoutParam != null && ignoreStoredLayoutParam.getValue() != null) {
            this.forceIgnoreStoredLayout = Boolean.parseBoolean(ignoreStoredLayoutParam.getValue().toLowerCase());
        }
    }

    public void start() {
        for (DynamicPortalLayoutMatcherPlugin dynamicLayoutMatcherPlugin : this.dynamicLayoutMatcherPlugins.values()) {
            dynamicLayoutMatcherPlugin.init(this.configurationManager);
        }
    }

    public void stop() {
    }

    public void addDynamicLayoutMatcher(DynamicPortalLayoutMatcherPlugin dynamicPortalLayoutMatcherPlugin) {
        if (dynamicPortalLayoutMatcherPlugin == null) {
            throw new IllegalArgumentException("plugin is null");
        }
        String matcherName = dynamicPortalLayoutMatcherPlugin.getName();
        if (this.dynamicLayoutMatcherPlugins.containsKey(matcherName)) {
            LOG.info("Redefine an existing matcher with name {}", new Object[]{matcherName});
            this.dynamicLayoutMatcherPlugins.remove(matcherName);
        }
        this.dynamicLayoutMatcherPlugins.put(matcherName, dynamicPortalLayoutMatcherPlugin);
    }

    public Collection<DynamicPortalLayoutMatcherPlugin> getDynamicLayoutMatchers() {
        return Collections.unmodifiableCollection(this.dynamicLayoutMatcherPlugins.values());
    }

    public PortalConfig getPortalConfigWithDynamicLayout(SiteKey siteKey, String currentPortalSiteName) throws Exception {
        if (siteKey == null) {
            throw new IllegalArgumentException("siteKey is mandatory");
        }
        PortalConfig storedPortalConfig = this.dataStorage.getPortalConfig(siteKey.getTypeName(), siteKey.getName());
        if (storedPortalConfig == null) {
            return null;
        }
        if (!storedPortalConfig.isDefaultLayout() && !this.forceIgnoreStoredLayout) {
            return storedPortalConfig;
        }
        if (StringUtils.isBlank((CharSequence)currentPortalSiteName)) {
            LOG.warn((Object)"Current portal site name is blank, thus return stored portal config");
            return storedPortalConfig;
        }
        if (StringUtils.equals((CharSequence)currentPortalSiteName, (CharSequence)siteKey.getName())) {
            return storedPortalConfig;
        }
        PortalConfig currentSitePortalConfig = this.dataStorage.getPortalConfig(SiteType.PORTAL.getName(), currentPortalSiteName);
        if (currentSitePortalConfig == null) {
            return storedPortalConfig;
        }
        for (DynamicPortalLayoutMatcherPlugin dynamicLayoutMatcherPlugin : this.dynamicLayoutMatcherPlugins.values()) {
            PortalConfig dynamicPortalConfig = dynamicLayoutMatcherPlugin.getPortalConfigWithDynamicLayout(siteKey, storedPortalConfig, currentSitePortalConfig);
            if (dynamicPortalConfig == null) continue;
            return dynamicPortalConfig;
        }
        return storedPortalConfig;
    }
}

