/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.Map;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;

final class DenseFeature
extends AbstractFeature
implements Cloneable {
    private static final long serialVersionUID = -2041120433733230588L;
    private final Map<String, Integer> indices;
    private Object[] properties;

    public DenseFeature(DefaultFeatureType defaultFeatureType) {
        super(defaultFeatureType);
        this.indices = defaultFeatureType.indices();
    }

    private int getIndex(String string) throws IllegalArgumentException {
        Integer n = this.indices.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException(DenseFeature.propertyNotFound(this.type, this.getName(), string));
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        Property property;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        int n = this.getIndex(string);
        if (n < 0) {
            return this.getOperationResult(string);
        }
        if (!(this.properties instanceof Property[])) {
            this.wrapValuesInProperties();
        }
        if ((property = ((Property[])this.properties)[n]) == null) {
            property = this.createProperty(string);
            this.properties[n] = property;
        }
        return property;
    }

    @Override
    public void setProperty(Object object) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"property", (Object)object);
        String string = ((Property)object).getName().toString();
        this.verifyPropertyType(string, (Property)object);
        if (!(this.properties instanceof Property[])) {
            this.wrapValuesInProperties();
        }
        this.properties[this.indices.get((Object)string).intValue()] = object;
    }

    private void wrapValuesInProperties() {
        Property[] propertyArray = new Property[this.indices.size()];
        if (this.properties != null) {
            assert (propertyArray.length == this.properties.length);
            for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
                Object object;
                int n = entry.getValue();
                if (n < 0 || (object = this.properties[n]) == null) continue;
                propertyArray[n] = this.createProperty(entry.getKey(), object);
            }
        }
        this.properties = propertyArray;
    }

    @Override
    public Object getPropertyValue(String string) throws IllegalArgumentException {
        Object object;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        int n = this.getIndex(string);
        if (n < 0) {
            return this.getOperationValue(string);
        }
        if (this.properties != null && (object = this.properties[n]) != null) {
            if (!(this.properties instanceof Property[])) {
                return object;
            }
            if (object instanceof AbstractAttribute) {
                return DenseFeature.getAttributeValue((AbstractAttribute)object);
            }
            if (object instanceof AbstractAssociation) {
                return DenseFeature.getAssociationValue((AbstractAssociation)object);
            }
            throw new IllegalArgumentException(DenseFeature.unsupportedPropertyType(((Property)object).getName()));
        }
        return this.getDefaultValue(string);
    }

    @Override
    public void setPropertyValue(String string, Object object) throws IllegalArgumentException {
        Property property;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        int n = this.getIndex(string);
        if (n < 0) {
            this.setOperationValue(string, object);
            return;
        }
        if (this.properties == null) {
            int n2 = this.indices.size();
            Object[] objectArray = this.properties = object != null ? new Object[n2] : new Property[n2];
        }
        if (!(this.properties instanceof Property[])) {
            if (object != null) {
                if (!DenseFeature.canSkipVerification(this.properties[n], object)) {
                    object = this.verifyPropertyValue(string, object);
                }
                this.properties[n] = object;
                return;
            }
            this.wrapValuesInProperties();
        }
        if ((property = ((Property[])this.properties)[n]) == null) {
            property = this.createProperty(string);
            this.properties[n] = property;
        }
        DenseFeature.setPropertyValue(property, object);
    }

    @Override
    public DataQuality quality() {
        if (this.properties != null && !(this.properties instanceof Property[])) {
            Validator validator = new Validator(ScopeCode.FEATURE);
            for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
                validator.validateAny(this.type.getProperty(entry.getKey()), this.properties[entry.getValue()]);
            }
            return validator.quality;
        }
        return super.quality();
    }

    public DenseFeature clone() throws CloneNotSupportedException {
        DenseFeature denseFeature = (DenseFeature)super.clone();
        denseFeature.properties = (Object[])denseFeature.properties.clone();
        if (denseFeature.properties instanceof Property[]) {
            Property[] propertyArray = (Property[])denseFeature.properties;
            Cloner cloner = new Cloner();
            for (int i = 0; i < propertyArray.length; ++i) {
                Property property = propertyArray[i];
                if (!(property instanceof Cloneable)) continue;
                propertyArray[i] = (Property)cloner.clone((Object)property);
            }
        }
        return denseFeature;
    }

    @Override
    public int hashCode() {
        int n = 1;
        if (this.properties != null) {
            if (this.properties instanceof Property[]) {
                for (Property property : (Property[])this.properties) {
                    Object object;
                    n = 31 * n;
                    if (property instanceof AbstractAttribute) {
                        object = DenseFeature.getAttributeValue((AbstractAttribute)property);
                    } else {
                        if (!(property instanceof AbstractAssociation)) continue;
                        object = DenseFeature.getAssociationValue((AbstractAssociation)property);
                    }
                    if (object == null) continue;
                    n += object.hashCode();
                }
            } else {
                n = Arrays.hashCode(this.properties);
            }
        }
        return this.type.hashCode() + n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DenseFeature) {
            DenseFeature denseFeature = (DenseFeature)object;
            if (this.type.equals(denseFeature.type)) {
                boolean bl = this.properties instanceof Property[];
                if (bl != denseFeature.properties instanceof Property[]) {
                    if (bl) {
                        denseFeature.wrapValuesInProperties();
                    } else {
                        this.wrapValuesInProperties();
                    }
                }
                return Arrays.equals(this.properties, denseFeature.properties);
            }
        }
        return false;
    }
}

