/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

public class BursaWolfParameters
extends FormattableObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 754825592343010900L;
    static final double PPM = 1000000.0;
    public double tX;
    public double tY;
    public double tZ;
    public double rX;
    public double rY;
    public double rZ;
    public double dS;
    private final GeodeticDatum targetDatum;
    private final Extent domainOfValidity;

    public BursaWolfParameters(GeodeticDatum geodeticDatum, Extent extent) {
        this.targetDatum = geodeticDatum;
        this.domainOfValidity = extent;
    }

    void verify(PrimeMeridian primeMeridian) throws IllegalArgumentException {
        PrimeMeridian primeMeridian2;
        if (this.targetDatum != null && (primeMeridian2 = this.targetDatum.getPrimeMeridian()).getGreenwichLongitude() != 0.0 && !Utilities.equalsIgnoreMetadata((Object)primeMeridian, (Object)primeMeridian2)) {
            throw new IllegalArgumentException(Resources.format((short)36, IdentifiedObjects.getName((IdentifiedObject)primeMeridian, null), IdentifiedObjects.getName((IdentifiedObject)primeMeridian2, null)));
        }
        ArgumentChecks.ensureFinite((String)"tX", (double)this.tX);
        ArgumentChecks.ensureFinite((String)"tY", (double)this.tY);
        ArgumentChecks.ensureFinite((String)"tZ", (double)this.tZ);
        ArgumentChecks.ensureFinite((String)"rX", (double)this.rX);
        ArgumentChecks.ensureFinite((String)"rY", (double)this.rY);
        ArgumentChecks.ensureFinite((String)"rZ", (double)this.rZ);
        ArgumentChecks.ensureBetween((String)"dS", (double)-1000000.0, (double)1000000.0, (double)this.dS);
    }

    public GeodeticDatum getTargetDatum() {
        return this.targetDatum;
    }

    public double[] getValues() {
        double[] dArray = new double[this.dS != 0.0 ? 7 : (this.rZ != 0.0 || this.rY != 0.0 || this.rX != 0.0 ? 6 : 3)];
        switch (dArray.length) {
            default: {
                dArray[6] = this.dS;
            }
            case 6: {
                dArray[5] = this.rZ;
                dArray[4] = this.rY;
                dArray[3] = this.rX;
            }
            case 3: 
        }
        dArray[2] = this.tZ;
        dArray[1] = this.tY;
        dArray[0] = this.tX;
        return dArray;
    }

    public void setValues(double ... dArray) {
        switch (dArray.length) {
            default: {
                this.dS = dArray[6];
            }
            case 6: {
                this.rZ = dArray[5];
            }
            case 5: {
                this.rY = dArray[4];
            }
            case 4: {
                this.rX = dArray[3];
            }
            case 3: {
                this.tZ = dArray[2];
            }
            case 2: {
                this.tY = dArray[1];
            }
            case 1: {
                this.tX = dArray[0];
            }
            case 0: 
        }
    }

    final boolean isToWGS84() {
        return this.targetDatum != null && IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)this.targetDatum, "WGS84");
    }

    public boolean isIdentity() {
        return this.tX == 0.0 && this.tY == 0.0 && this.tZ == 0.0 && this.isTranslation();
    }

    public boolean isTranslation() {
        return this.rX == 0.0 && this.rY == 0.0 && this.rZ == 0.0 && this.dS == 0.0;
    }

    public void reverseRotation() {
        this.rX = -this.rX;
        this.rY = -this.rY;
        this.rZ = -this.rZ;
    }

    public void invert() {
        double[] dArray = this.getValues();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = -dArray[i];
        }
        this.setValues(dArray);
    }

    DoubleDouble period(Date date) {
        return null;
    }

    DoubleDouble param(int n, DoubleDouble doubleDouble) {
        double d;
        switch (n) {
            case 0: {
                d = this.tX;
                break;
            }
            case 1: {
                d = this.tY;
                break;
            }
            case 2: {
                d = this.tZ;
                break;
            }
            case 3: {
                d = this.rX;
                break;
            }
            case 4: {
                d = this.rY;
                break;
            }
            case 5: {
                d = this.rZ;
                break;
            }
            case 6: {
                d = this.dS;
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        return DoubleDouble.createAndGuessError((double)d);
    }

    public Matrix getPositionVectorTransformation(Date date) {
        DoubleDouble doubleDouble = this.period(date);
        if (doubleDouble == null && this.isTranslation()) {
            Matrix4 matrix4 = new Matrix4();
            matrix4.m03 = this.tX;
            matrix4.m13 = this.tY;
            matrix4.m23 = this.tZ;
            return matrix4;
        }
        DoubleDouble doubleDouble2 = DoubleDouble.createSecondsToRadians();
        DoubleDouble doubleDouble3 = this.param(6, doubleDouble);
        doubleDouble3.divide(1000000.0);
        doubleDouble3.add(1.0);
        doubleDouble2.multiply(doubleDouble3);
        DoubleDouble doubleDouble4 = this.param(3, doubleDouble);
        doubleDouble4.multiply(doubleDouble2);
        DoubleDouble doubleDouble5 = this.param(4, doubleDouble);
        doubleDouble5.multiply(doubleDouble2);
        DoubleDouble doubleDouble6 = this.param(5, doubleDouble);
        doubleDouble6.multiply(doubleDouble2);
        DoubleDouble doubleDouble7 = new DoubleDouble(doubleDouble4);
        doubleDouble7.negate();
        DoubleDouble doubleDouble8 = new DoubleDouble(doubleDouble5);
        doubleDouble8.negate();
        DoubleDouble doubleDouble9 = new DoubleDouble(doubleDouble6);
        doubleDouble9.negate();
        Integer n = 0;
        return Matrices.create(4, 4, new Number[]{doubleDouble3, doubleDouble9, doubleDouble5, this.param(0, doubleDouble), doubleDouble6, doubleDouble3, doubleDouble7, this.param(1, doubleDouble), doubleDouble8, doubleDouble4, doubleDouble3, this.param(2, doubleDouble), n, n, n, 1});
    }

    public void setPositionVectorTransformation(Matrix matrix, double d) throws IllegalArgumentException {
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        if (n != 4 || n2 != 4) {
            Integer n3 = 4;
            throw new IllegalArgumentException(Errors.format((short)83, (Object)n3, (Object)n3, (Object)n, (Object)n2));
        }
        if (!Matrices.isAffine(matrix)) {
            throw new IllegalArgumentException(Resources.format((short)59));
        }
        this.tX = matrix.getElement(0, 3);
        this.tY = matrix.getElement(1, 3);
        this.tZ = matrix.getElement(2, 3);
        if (Matrices.isTranslation(matrix)) {
            return;
        }
        DoubleDouble doubleDouble = DoubleDouble.castOrCopy((Number)BursaWolfParameters.getNumber(matrix, 0, 0));
        doubleDouble.addGuessError(BursaWolfParameters.getNumber(matrix, 1, 1));
        doubleDouble.addGuessError(BursaWolfParameters.getNumber(matrix, 2, 2));
        doubleDouble.divide(3.0);
        DoubleDouble doubleDouble2 = DoubleDouble.createSecondsToRadians();
        doubleDouble2.multiply(doubleDouble);
        doubleDouble.add(-1.0);
        doubleDouble.multiply(1000000.0);
        this.dS = doubleDouble.doubleValue();
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs((matrix.getElement(i, i) - 1.0) * 1000000.0 - this.dS) <= d)) {
                throw new IllegalArgumentException(Resources.format((short)57));
            }
            block6: for (int j = i + 1; j < 3; ++j) {
                doubleDouble.setFrom(doubleDouble2);
                doubleDouble.inverseDivideGuessError(BursaWolfParameters.getNumber(matrix, i, j));
                double d2 = doubleDouble.value;
                double d3 = doubleDouble.error;
                doubleDouble.setFrom(doubleDouble2);
                doubleDouble.inverseDivideGuessError(BursaWolfParameters.getNumber(matrix, j, i));
                if (!(Math.abs(d2 + doubleDouble.value) <= d)) {
                    throw new IllegalArgumentException(Resources.format((short)58));
                }
                doubleDouble.subtract(d2, d3);
                doubleDouble.multiply(0.5);
                d2 = doubleDouble.doubleValue();
                switch (i * 4 + j) {
                    case 1: {
                        this.rZ = d2;
                        continue block6;
                    }
                    case 2: {
                        this.rY = -d2;
                        continue block6;
                    }
                    case 6: {
                        this.rX = d2;
                    }
                }
            }
        }
    }

    private static Number getNumber(Matrix matrix, int n, int n2) {
        if (matrix instanceof MatrixSIS) {
            return ((MatrixSIS)matrix).getNumber(n, n2);
        }
        return matrix.getElement(n, n2);
    }

    public Extent getDomainOfValidity() {
        if (this.domainOfValidity == null && this.targetDatum != null) {
            return this.targetDatum.getDomainOfValidity();
        }
        return this.domainOfValidity;
    }

    public BursaWolfParameters clone() {
        try {
            return (BursaWolfParameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            BursaWolfParameters bursaWolfParameters = (BursaWolfParameters)object;
            return Arrays.equals(this.getValues(), bursaWolfParameters.getValues()) && Objects.equals(this.targetDatum, bursaWolfParameters.targetDatum) && Objects.equals(this.domainOfValidity, bursaWolfParameters.domainOfValidity);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getValues()) ^ 0x82FA9E54;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String formatTo(Formatter formatter) {
        void var3_6;
        double[] dArray;
        for (double d : dArray = this.getValues()) {
            formatter.append(d);
        }
        if (this.isToWGS84()) {
            if (dArray.length > 7) {
                formatter.setInvalidWKT(BursaWolfParameters.class, null);
            }
            return "ToWGS84";
        }
        formatter.setInvalidWKT(BursaWolfParameters.class, null);
        String string = IdentifiedObjects.getSimpleNameOrIdentifier((IdentifiedObject)this.getTargetDatum());
        if (string == null) {
            String string2 = "Unknown";
        }
        return "To" + (String)var3_6;
    }
}

