/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.sis.index.tree.NodeType;
import org.apache.sis.index.tree.QuadTree;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.index.tree.Quadrant;

public final class QuadTreeWriter {
    private QuadTreeWriter() {
    }

    public static void writeTreeToFile(QuadTree quadTree, String string) throws IOException {
        QuadTreeWriter.createIdxDir(string);
        QuadTreeWriter.writeTreeConfigsToFile(quadTree, string);
        QuadTreeWriter.writeNodeToFile(quadTree.getRoot(), string);
    }

    private static void createIdxDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("[INFO] Creating qtree idx dir: [" + string + "]");
            new File(string).mkdirs();
        }
    }

    private static void writeTreeConfigsToFile(QuadTree quadTree, String string) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + "tree_config.txt"));){
            bufferedWriter.write("capacity;" + quadTree.getCapacity() + ";depth;" + quadTree.getDepth());
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
    }

    private static void writeChildrenToFile(QuadTreeNode quadTreeNode, Quadrant quadrant, BufferedWriter bufferedWriter, String string, boolean bl) throws IOException {
        if (bl) {
            if (quadTreeNode.getChild(quadrant) != null && quadTreeNode.getChild(quadrant).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(quadTreeNode.getChild(quadrant), string);
            }
        } else if (quadTreeNode.getChild(quadrant) != null) {
            bufferedWriter.write(QuadTreeWriter.getQuadTreeDataString(quadrant, quadTreeNode.getChild(quadrant)));
            bufferedWriter.newLine();
        }
    }

    private static void writeNodeToFile(QuadTreeNode quadTreeNode, String string) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + "node_" + quadTreeNode.getId() + ".txt"));){
            if (quadTreeNode.getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.NW, bufferedWriter, string, false);
                QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.NE, bufferedWriter, string, false);
                QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.SW, bufferedWriter, string, false);
                QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.SE, bufferedWriter, string, false);
            }
        }
        if (quadTreeNode.getNodeType() == NodeType.GRAY) {
            QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.NW, null, string, true);
            QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.NE, null, string, true);
            QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.SW, null, string, true);
            QuadTreeWriter.writeChildrenToFile(quadTreeNode, Quadrant.SE, null, string, true);
        }
    }

    private static String getQuadTreeDataString(Quadrant quadrant, QuadTreeNode quadTreeNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(quadrant.index());
        stringBuilder.append(':');
        stringBuilder.append(quadTreeNode.getNodeType().toString());
        stringBuilder.append(':');
        stringBuilder.append(quadTreeNode.getId());
        stringBuilder.append(':');
        stringBuilder.append(quadTreeNode.getCapacity());
        stringBuilder.append(':');
        QuadTreeData[] quadTreeDataArray = quadTreeNode.getData();
        for (int i = 0; i < quadTreeNode.getCount(); ++i) {
            stringBuilder.append(quadTreeDataArray[i].getLatLon().y);
            stringBuilder.append(';');
            stringBuilder.append(quadTreeDataArray[i].getLatLon().x);
            stringBuilder.append(';');
            stringBuilder.append(quadTreeDataArray[i].getFileName());
            stringBuilder.append(':');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }
}

