/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.plugin;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class EventReminderNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(EventReminderNotificationPlugin.class);
    private static final String AGENDA_NOTIFICATION_PLUGIN_NAME = "agenda.notification.plugin.key";
    private String notificationId;
    private AgendaEventService eventService;
    private IdentityManager identityManager;
    private AgendaCalendarService calendarService;

    public EventReminderNotificationPlugin(InitParams initParams, IdentityManager identityManager, AgendaEventService eventService, AgendaCalendarService calendarService) {
        super(initParams);
        this.identityManager = identityManager;
        this.eventService = eventService;
        this.calendarService = calendarService;
        ValueParam notificationIdParam = initParams.getValueParam(AGENDA_NOTIFICATION_PLUGIN_NAME);
        if (notificationIdParam == null || StringUtils.isBlank((String)notificationIdParam.getValue())) {
            throw new IllegalStateException("'agenda.notification.plugin.key' parameter is mandatory");
        }
        this.notificationId = notificationIdParam.getValue();
    }

    public String getId() {
        return this.notificationId;
    }

    public boolean isValid(NotificationContext ctx) {
        if (NotificationUtils.getEventReminderId(ctx) == 0L) {
            LOG.warn("Notification type '{}' isn't valid because the event reminder wasn't found", new Object[]{this.getId()});
            return false;
        }
        return true;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        EventReminder eventReminder = (EventReminder)ctx.value(NotificationUtils.EVENT_AGENDA_REMINDER);
        Event event = this.eventService.getEventById(eventReminder.getEventId());
        Calendar calendar = this.calendarService.getCalendarById(event.getCalendarId());
        NotificationInfo notification = NotificationInfo.instance();
        notification.key(this.getId());
        if (eventReminder.getId() > 0L) {
            NotificationUtils.setEventReminderNotificationRecipients(this.identityManager, notification, eventReminder.getReceiverId());
        }
        if (notification.getSendToUserIds() == null || notification.getSendToUserIds().isEmpty()) {
            LOG.debug("Notification type '{}' doesn't have a recipient", new Object[]{this.getId()});
            return null;
        }
        NotificationUtils.storeEventParameters(notification, event, calendar);
        return notification.end();
    }
}

