/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.DataTransfer;
import org.apache.sis.internal.storage.io.MemoryDataTransfer;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.resources.Errors;

public final class HyperRectangleReader {
    private final DataTransfer reader;
    public final long origin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperRectangleReader(byte by, ChannelDataInput channelDataInput, long l) throws DataStoreContentException {
        switch (by) {
            case 3: {
                ChannelDataInput channelDataInput2 = channelDataInput;
                Objects.requireNonNull(channelDataInput2);
                this.reader = new ChannelDataInput.BytesReader(channelDataInput2, null);
                break;
            }
            case 2: {
                ChannelDataInput channelDataInput3 = channelDataInput;
                Objects.requireNonNull(channelDataInput3);
                this.reader = new ChannelDataInput.CharsReader(channelDataInput3, (char[])null);
                break;
            }
            case 4: {
                ChannelDataInput channelDataInput4 = channelDataInput;
                Objects.requireNonNull(channelDataInput4);
                this.reader = new ChannelDataInput.ShortsReader(channelDataInput4, (short[])null);
                break;
            }
            case 5: {
                ChannelDataInput channelDataInput5 = channelDataInput;
                Objects.requireNonNull(channelDataInput5);
                this.reader = new ChannelDataInput.IntsReader(channelDataInput5, (int[])null);
                break;
            }
            case 6: {
                ChannelDataInput channelDataInput6 = channelDataInput;
                Objects.requireNonNull(channelDataInput6);
                this.reader = new ChannelDataInput.LongsReader(channelDataInput6, (long[])null);
                break;
            }
            case 8: {
                ChannelDataInput channelDataInput7 = channelDataInput;
                Objects.requireNonNull(channelDataInput7);
                this.reader = new ChannelDataInput.FloatsReader(channelDataInput7, (float[])null);
                break;
            }
            case 9: {
                ChannelDataInput channelDataInput8 = channelDataInput;
                Objects.requireNonNull(channelDataInput8);
                this.reader = new ChannelDataInput.DoublesReader(channelDataInput8, (double[])null);
                break;
            }
            default: {
                throw new DataStoreContentException(Errors.format((short)149, (Object)by));
            }
        }
        this.origin = l;
        ByteBuffer byteBuffer = channelDataInput.buffer;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        try {
            byteBuffer.position(0).limit(byteBuffer.capacity());
            this.reader.createView();
        }
        finally {
            byteBuffer.limit(n2).position(n);
        }
    }

    public HyperRectangleReader(String string, Buffer buffer) throws IOException {
        this.reader = new MemoryDataTransfer(string, buffer).reader();
        this.origin = 0L;
    }

    public String filename() {
        return this.reader.filename();
    }

    public int dataSize() {
        return 1 << this.reader.dataSizeShift();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Region region) throws IOException {
        int n = region.contiguousDataDimension();
        int n2 = region.targetLength(n);
        long[] lArray = new long[region.getDimension() - n];
        int[] nArray = new int[lArray.length];
        int n3 = this.reader.dataSizeShift();
        long l = this.origin + (region.startAt << n3);
        int n4 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = region.skips[i + n] + (long)n2 << n3;
            assert (lArray[i] > 0L) : i;
        }
        try {
            this.reader.createDataArray(region.targetLength(region.getDimension()));
            Buffer buffer = this.reader.view();
            block4: while (true) {
                this.reader.seek(l);
                assert (this.reader.view() == buffer);
                this.reader.readFully(buffer, n4, n2);
                for (int i = 0; i < nArray.length; ++i) {
                    int n5 = i;
                    nArray[n5] = nArray[n5] + 1;
                    if (nArray[n5] < region.targetSize[n + i]) {
                        l += lArray[i];
                        n4 += n2;
                        continue block4;
                    }
                    nArray[i] = 0;
                }
                break;
            }
            Object object = this.reader.dataArray();
            return object;
        }
        finally {
            this.reader.setDest(null);
        }
    }
}

