/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk9;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.sis.internal.util.UnmodifiableArrayList;

public final class JDK9 {
    private JDK9() {
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(EArray[0]);
            }
        }
        return UnmodifiableArrayList.wrap(EArray);
    }

    @SafeVarargs
    public static <E> Set<E> setOf(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(EArray[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(EArray)));
    }

    public static Buffer slice(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).slice();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).slice();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).slice();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).slice();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).slice();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).slice();
        }
        throw new IllegalArgumentException();
    }

    public static Buffer duplicate(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).duplicate();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).duplicate();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).duplicate();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).duplicate();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).duplicate();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).duplicate();
        }
        throw new IllegalArgumentException();
    }
}

