/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import juzu.Response;
import juzu.Scope;
import juzu.asset.AssetLocation;
import juzu.impl.bridge.Parameters;
import juzu.impl.bridge.spi.DispatchBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.common.RunMode;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopingContext;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.controller.ControllerService;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.BeanParameter;
import juzu.impl.request.ContextLifeCycle;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.ExecutionFilter;
import juzu.impl.request.PhaseParameter;
import juzu.impl.request.Stage;
import juzu.impl.value.ValueType;
import juzu.io.UndeclaredIOException;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.Dispatch;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestParameter;
import juzu.request.SecurityContext;
import juzu.request.UserContext;

public class Request
implements ScopingContext {
    private static final Object[] EMPTY = new Object[0];
    static final ThreadLocal<ContextLifeCycle> current = new ThreadLocal();
    final LinkedHashSet<ContextLifeCycle> contextLifeCycles = new LinkedHashSet();
    BeanLifeCycle controllerLifeCycle = null;
    final RequestBridge bridge;
    final ControllerService controllerPlugin;
    final ControllerHandler<?> handler;
    private Map<String, RequestParameter> parameterArguments;
    private Map<ContextualParameter, Object> contextualArguments;
    private ContextLifeCycle contextLifeCycle;

    public static Request getCurrent() {
        ContextLifeCycle context = current.get();
        return context != null ? context.getRequest() : null;
    }

    public Request(ControllerService controllerPlugin, ControllerHandler handler, RequestBridge bridge) {
        this.bridge = bridge;
        this.controllerPlugin = controllerPlugin;
        this.handler = handler;
        this.parameterArguments = new HashMap<String, RequestParameter>();
        this.contextualArguments = new HashMap<ContextualParameter, Object>();
    }

    public Map<String, RequestParameter> getParameterArguments() {
        return this.parameterArguments;
    }

    public Map<ContextualParameter, Object> getContextualArguments() {
        return this.contextualArguments;
    }

    public RunMode getRunMode() {
        return this.bridge.getRunMode();
    }

    public Application getApplication() {
        return this.controllerPlugin.getApplication();
    }

    public ClientContext getClientContext() {
        return this.bridge.getClientContext();
    }

    public HttpContext getHttpContext() {
        return this.getBridge().getHttpContext();
    }

    public SecurityContext getSecurityContext() {
        return this.getBridge().getSecurityContext();
    }

    public UserContext getUserContext() {
        return this.getBridge().getUserContext();
    }

    public ApplicationContext getApplicationContext() {
        return this.getBridge().getApplicationContext();
    }

    public ControllerHandler<?> getHandler() {
        return this.handler;
    }

    public Phase getPhase() {
        return this.handler.getPhase();
    }

    public ScopeController getScopeController() {
        return this.controllerPlugin.getInjectionContext().getScopeController();
    }

    public RequestBridge getBridge() {
        return this.bridge;
    }

    @Override
    public final Scoped getContextualValue(Scope scope, Object key) {
        ScopedContext context = this.bridge.getScopedContext(scope, false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setContextualValue(Scope scope, Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.bridge.getScopedContext(scope, false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.bridge.getScopedContext(scope, true).set(key, value);
        }
    }

    @Override
    public boolean isActive(Scope scope) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke() {
        boolean set = current.get() == null;
        try {
            if (set) {
                this.contextLifeCycle = new ContextLifeCycle(this);
                current.set(this.contextLifeCycle);
                this.getScopeController().begin(this);
            }
            Stage.Unmarshalling stage = new Stage.Unmarshalling(this);
            Response response = stage.invoke();
            return response;
        }
        finally {
            if (set) {
                this.contextLifeCycle.endContextual();
                current.set(null);
            }
        }
    }

    public Executor getExecutor() {
        final Iterable<ExecutionFilter> filters = this.controllerPlugin.getInjectionContext().resolveInstances(ExecutionFilter.class);
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                for (ExecutionFilter filter : filters) {
                    command = filter.onCommand(command);
                }
                Request.this.execute(command);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(final Runnable runnable) throws RejectedExecutionException {
        final ContextLifeCycle contextLifeCycle = new ContextLifeCycle(this);
        this.contextLifeCycles.add(contextLifeCycle);
        Runnable wrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Request.this.getScopeController().begin(Request.this);
                    current.set(contextLifeCycle);
                    runnable.run();
                }
                finally {
                    current.set(null);
                    contextLifeCycle.endContextual();
                }
            }
        };
        boolean executed = false;
        try {
            this.bridge.execute(wrapper);
            executed = true;
        }
        finally {
            if (!executed) {
                contextLifeCycle.endContextual();
            }
        }
    }

    public ContextLifeCycle suspend() {
        ContextLifeCycle lifeCycle = current.get();
        if (lifeCycle == null) {
            throw new IllegalStateException("No current active request");
        }
        if (lifeCycle.getRequest() != this) {
            throw new IllegalStateException("Current request is not active");
        }
        current.set(null);
        return lifeCycle;
    }

    private Dispatch createDispatch(ControllerHandler<?> handler, DispatchBridge spi) {
        Dispatch dispatch;
        ControllersDescriptor desc = this.controllerPlugin.getDescriptor();
        if (handler.getPhase() == Phase.ACTION) {
            dispatch = new Phase.Action.Dispatch(spi);
        } else if (handler.getPhase() == Phase.VIEW) {
            dispatch = new Phase.View.Dispatch(spi);
            dispatch.escapeXML(desc.getEscapeXML());
        } else if (handler.getPhase() == Phase.RESOURCE) {
            dispatch = new Phase.Resource.Dispatch(spi);
            dispatch.escapeXML(desc.getEscapeXML());
        } else {
            throw new AssertionError();
        }
        dispatch.escapeXML(desc.getEscapeXML());
        return dispatch;
    }

    private String valueOf(AnnotatedElement annotated, Object o) {
        ValueType<?> vt = this.controllerPlugin.resolveValueType(o.getClass());
        if (vt != null) {
            return vt.format(annotated, o);
        }
        return null;
    }

    private void setArgs(Object[] args, Parameters parameterMap, ControllerHandler<?> handler) {
        int index = 0;
        for (ControlParameter parameter : handler.getParameters()) {
            if (parameter instanceof PhaseParameter) {
                int at;
                Object value;
                PhaseParameter phaseParameter = (PhaseParameter)parameter;
                if ((value = args[at = index++]) == null) continue;
                String name = phaseParameter.getMappedName();
                switch (phaseParameter.getCardinality()) {
                    case SINGLE: {
                        parameterMap.setParameter(name, this.valueOf(phaseParameter.getAnnotations(), value));
                        break;
                    }
                    case ARRAY: {
                        int length = Array.getLength(value);
                        String[] array = new String[length];
                        for (int i = 0; i < length; ++i) {
                            Object component = Array.get(value, i);
                            array[i] = this.valueOf(phaseParameter.getAnnotations(), component);
                        }
                        parameterMap.setParameter(name, array);
                        break;
                    }
                    case LIST: {
                        Collection c = (Collection)value;
                        int length = c.size();
                        String[] array = new String[length];
                        Iterator iterator = c.iterator();
                        for (int i = 0; i < length; ++i) {
                            Object element = iterator.next();
                            array[i] = this.valueOf(phaseParameter.getAnnotations(), element);
                        }
                        parameterMap.setParameter(name, array);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not yet implemented");
                    }
                }
                continue;
            }
            if (!(parameter instanceof BeanParameter)) continue;
            BeanParameter beanParameter = (BeanParameter)parameter;
            Object value = args[index++];
            Map<String, String[]> p = beanParameter.buildBeanParameter(this.controllerPlugin, handler.requiresPrefix, beanParameter.getName(), value);
            parameterMap.setParameters(p);
        }
    }

    public Dispatch createDispatch(ControllerHandler<?> handler, Object[] args) {
        Parameters parameters = new Parameters();
        this.setArgs(args, parameters, handler);
        DispatchBridge spi = this.getBridge().createDispatch((Phase)handler.getPhase(), handler.getHandle(), parameters);
        return this.createDispatch(handler, spi);
    }

    public Dispatch createDispatch(ControllerHandler<?> handler) {
        DispatchBridge spi = this.getBridge().createDispatch((Phase)handler.getPhase(), handler.getHandle(), new Parameters());
        return this.createDispatch(handler, spi);
    }

    private static Dispatch safeCreateDispatch(ControllerHandler<?> handler, Object[] args) {
        ContextLifeCycle context = current.get();
        if (context != null) {
            return context.getRequest().createDispatch(handler, args);
        }
        return null;
    }

    public static Phase.Action.Dispatch createActionDispatch(ControllerHandler<Phase.Action> handler) {
        return (Phase.Action.Dispatch)Request.safeCreateDispatch(handler, EMPTY);
    }

    public static Phase.Action.Dispatch createActionDispatch(ControllerHandler<Phase.Action> handler, Object arg) {
        return (Phase.Action.Dispatch)Request.safeCreateDispatch(handler, new Object[]{arg});
    }

    public static Phase.Action.Dispatch createActionDispatch(ControllerHandler<Phase.Action> handler, Object[] args) {
        return (Phase.Action.Dispatch)Request.safeCreateDispatch(handler, args);
    }

    public static Phase.View.Dispatch createViewDispatch(ControllerHandler<Phase.View> handler) {
        return (Phase.View.Dispatch)Request.safeCreateDispatch(handler, EMPTY);
    }

    public static Phase.View.Dispatch createViewDispatch(ControllerHandler<Phase.View> handler, Object arg) {
        return (Phase.View.Dispatch)Request.safeCreateDispatch(handler, new Object[]{arg});
    }

    public static Phase.View.Dispatch createViewDispatch(ControllerHandler<Phase.View> handler, Object[] args) {
        return (Phase.View.Dispatch)Request.safeCreateDispatch(handler, args);
    }

    public static Phase.Resource.Dispatch createResourceDispatch(ControllerHandler<Phase.Resource> handler) {
        return (Phase.Resource.Dispatch)Request.safeCreateDispatch(handler, EMPTY);
    }

    public static Phase.Resource.Dispatch createResourceDispatch(ControllerHandler<Phase.Resource> handler, Object arg) {
        return (Phase.Resource.Dispatch)Request.safeCreateDispatch(handler, new Object[]{arg});
    }

    public static Phase.Resource.Dispatch createResourceDispatch(ControllerHandler<Phase.Resource> handler, Object[] args) {
        return (Phase.Resource.Dispatch)Request.safeCreateDispatch(handler, args);
    }

    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws NullPointerException, UnsupportedOperationException, UndeclaredIOException {
        try {
            this.getBridge().renderAssetURL(location, uri, appendable);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }
}

