/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;

public class CNDStreamWriter {
    private final NamespaceRegistryImpl namespaceRegistry;
    private final LocationFactory locationFactory;

    public CNDStreamWriter(NamespaceRegistryImpl namespaceRegistry) {
        this.namespaceRegistry = namespaceRegistry;
        this.locationFactory = new LocationFactory(namespaceRegistry);
    }

    public void write(List<NodeTypeData> nodeTypes, OutputStream os) throws RepositoryException {
        OutputStreamWriter out = new OutputStreamWriter(os);
        try {
            for (NodeTypeData nodeType : nodeTypes) {
                this.printNamespaces(nodeType, out);
                this.printNodeTypeDeclaration(nodeType, out);
            }
            out.close();
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private void printNamespaces(NodeTypeData nodeTypeData, OutputStreamWriter out) throws RepositoryException, IOException {
        HashSet<String> namespaces = new HashSet<String>();
        this.printNameNamespace(nodeTypeData.getName(), namespaces);
        this.printNameNamespace(nodeTypeData.getPrimaryItemName(), namespaces);
        if (nodeTypeData.getDeclaredSupertypeNames() != null) {
            for (InternalQName reqType : nodeTypeData.getDeclaredSupertypeNames()) {
                this.printNameNamespace(reqType, namespaces);
            }
        }
        if (nodeTypeData.getDeclaredPropertyDefinitions() != null) {
            for (PropertyDefinitionData property : nodeTypeData.getDeclaredPropertyDefinitions()) {
                this.printNameNamespace(property.getName(), namespaces);
            }
        }
        if (nodeTypeData.getDeclaredChildNodeDefinitions() != null) {
            for (NodeDefinitionData child : nodeTypeData.getDeclaredChildNodeDefinitions()) {
                this.printNameNamespace(child.getName(), namespaces);
                this.printNameNamespace(child.getDefaultPrimaryType(), namespaces);
                if (child.getRequiredPrimaryTypes() == null) continue;
                for (InternalQName reqType : child.getRequiredPrimaryTypes()) {
                    this.printNameNamespace(reqType, namespaces);
                }
            }
        }
        for (String prefix : namespaces) {
            String uri = this.namespaceRegistry.getURI(prefix);
            out.write("<" + prefix + "='" + uri + "'>\r\n");
        }
    }

    private void printNameNamespace(InternalQName name, Set<String> namespaces) throws RepositoryException {
        String prefix;
        if (name != null && !this.namespaceRegistry.isDefaultPrefix(prefix = this.locationFactory.createJCRName(name).getPrefix())) {
            namespaces.add(prefix);
        }
    }

    private void printNodeTypeDeclaration(NodeTypeData nodeTypeData, OutputStreamWriter out) throws RepositoryException, IOException {
        NodeDefinitionData[] nodeDefinitions;
        PropertyDefinitionData[] propertyDefinitions;
        out.write("[" + this.qNameToString(nodeTypeData.getName()) + "] ");
        InternalQName[] superTypes = nodeTypeData.getDeclaredSupertypeNames();
        if (!(superTypes == null || superTypes.length <= 0 || superTypes.length <= 1 && superTypes[0].equals((Object)Constants.NT_BASE))) {
            out.write("> " + this.qNameToString(superTypes[0]));
            for (int i = 1; i < superTypes.length; ++i) {
                out.write(", " + this.qNameToString(superTypes[i]));
            }
        }
        StringBuilder attributes = new StringBuilder();
        if (nodeTypeData.hasOrderableChildNodes()) {
            attributes.append("orderable ");
        }
        if (nodeTypeData.isMixin()) {
            attributes.append("mixin ");
        }
        if (nodeTypeData.getPrimaryItemName() != null) {
            attributes.append("primaryitem " + this.qNameToString(nodeTypeData.getPrimaryItemName()));
        }
        if (attributes.length() > 0) {
            out.write("\r\n  ");
            out.write(attributes.toString());
        }
        if ((propertyDefinitions = nodeTypeData.getDeclaredPropertyDefinitions()) != null) {
            for (PropertyDefinitionData propertyDefinition : propertyDefinitions) {
                this.printPropertyDeclaration(propertyDefinition, out);
            }
        }
        if ((nodeDefinitions = nodeTypeData.getDeclaredChildNodeDefinitions()) != null) {
            for (NodeDefinitionData nodeDefinition : nodeDefinitions) {
                this.printChildDeclaration(nodeDefinition, out);
            }
        }
        out.write("\r\n");
    }

    private void printPropertyDeclaration(PropertyDefinitionData propertyDefinition, OutputStreamWriter out) throws IOException, RepositoryException {
        out.write("\r\n  ");
        out.write("- " + this.qNameToString(propertyDefinition.getName()));
        out.write(" (" + ExtendedPropertyType.nameFromValue(propertyDefinition.getRequiredType()).toUpperCase() + ")");
        out.write(this.listToString(propertyDefinition.getDefaultValues(), "'", "\r\n    = ", " "));
        StringBuilder attributes = new StringBuilder();
        if (propertyDefinition.isAutoCreated()) {
            attributes.append("autocreated ");
        }
        if (propertyDefinition.isMandatory()) {
            attributes.append("mandatory ");
        }
        if (propertyDefinition.isProtected()) {
            attributes.append("protected ");
        }
        if (propertyDefinition.isMultiple()) {
            attributes.append("multiple ");
        }
        if (propertyDefinition.getOnParentVersion() != 1) {
            attributes.append("\r\n    " + OnParentVersionAction.nameFromValue((int)propertyDefinition.getOnParentVersion()) + " ");
        }
        if (attributes.length() > 0) {
            out.write("\r\n    ");
            out.write(attributes.toString());
        }
        out.write(this.listToString(propertyDefinition.getValueConstraints(), "'", "\r\n    < ", " "));
    }

    private void printChildDeclaration(NodeDefinitionData nodeDefinition, OutputStreamWriter out) throws IOException, RepositoryException {
        out.write("\r\n  ");
        out.write("+ " + this.qNameToString(nodeDefinition.getName()) + " ");
        InternalQName[] requiredTypes = nodeDefinition.getRequiredPrimaryTypes();
        if (!(requiredTypes == null || requiredTypes.length <= 0 || requiredTypes.length <= 1 && requiredTypes[0].equals((Object)Constants.NT_BASE))) {
            out.write("(" + this.qNameToString(requiredTypes[0]));
            for (int i = 1; i < requiredTypes.length; ++i) {
                out.write(", " + this.qNameToString(requiredTypes[i]));
            }
            out.write(")");
        }
        if (nodeDefinition.getDefaultPrimaryType() != null) {
            out.write("\r\n    = " + this.qNameToString(nodeDefinition.getDefaultPrimaryType()));
        }
        StringBuilder attributes = new StringBuilder();
        if (nodeDefinition.isAutoCreated()) {
            attributes.append("autocreated ");
        }
        if (nodeDefinition.isMandatory()) {
            attributes.append("mandatory ");
        }
        if (nodeDefinition.isProtected()) {
            attributes.append("protected ");
        }
        if (nodeDefinition.isAllowsSameNameSiblings()) {
            attributes.append("sns ");
        }
        if (nodeDefinition.getOnParentVersion() != 1) {
            attributes.append("\r\n    " + OnParentVersionAction.nameFromValue((int)nodeDefinition.getOnParentVersion()) + " ");
        }
        if (attributes.length() > 0) {
            out.write("\r\n    ");
            out.write(attributes.toString());
        }
    }

    private String listToString(String[] list, String quote, String beforeString, String afterString) {
        StringBuilder result = new StringBuilder();
        if (list != null && list.length > 0) {
            result.append(beforeString);
            result.append(quote + list[0] + quote);
            for (int i = 1; i < list.length; ++i) {
                result.append(", " + quote + list[i] + quote);
            }
            result.append(afterString);
        }
        return result.toString();
    }

    private String qNameToString(InternalQName qName) throws RepositoryException {
        return this.locationFactory.createJCRName(qName).getAsString();
    }
}

