/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.templates.UIDialogTab;
import org.exoplatform.ecm.webui.component.admin.templates.UISkinTab;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContainer;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateEditForm;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateForm;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTab;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/template/UITemplateList.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UITemplateList.msg.confirm-delete"), @EventConfig(listeners={AddNewActionListener.class})})
public class UITemplateList
extends UIPagingGrid {
    private static String[] NODETYPE_BEAN_FIELD = new String[]{"icon", "label", "name"};
    private static String[] NODETYPE_ACTION = new String[]{"Edit", "Delete"};
    public static final String DOCUMENTS_TEMPLATE_TYPE = "templates";
    public static final String ACTIONS_TEMPLATE_TYPE = "actions";
    public static final String OTHERS_TEMPLATE_TYPE = "others";
    public static final String LABEL_PROPERTY = "label";
    public static final String ICON_FIELD = "icon";
    public static final String LABEL_FIELD = "label";
    private String filter = "templates";

    public void setTemplateFilter(String filter) {
        this.filter = filter;
    }

    public String getTemplateFilter() {
        return this.filter;
    }

    public UITemplateList() throws Exception {
        this.configure("name", NODETYPE_BEAN_FIELD, NODETYPE_ACTION);
    }

    public String[] getActions() {
        return new String[]{"AddNew"};
    }

    public void refresh(int currentPage) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentNodeTypes = templateService.getAllDocumentNodeTypes();
        Node templatesHome = templateService.getTemplatesHome(WCMCoreUtils.getSystemSessionProvider());
        ArrayList<TemplateData> templateData = new ArrayList<TemplateData>();
        if (templatesHome != null) {
            NodeTypeManager ntManager = templatesHome.getSession().getWorkspace().getNodeTypeManager();
            NodeTypeIterator nodetypeIter = ntManager.getAllNodeTypes();
            ArrayList<String> listNodeTypeName = new ArrayList<String>();
            while (nodetypeIter.hasNext()) {
                NodeType n1 = nodetypeIter.nextNodeType();
                listNodeTypeName.add(n1.getName());
            }
            NodeIterator nodes = templatesHome.getNodes();
            String label = "";
            Object icon = "";
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (!listNodeTypeName.contains(node.getName())) continue;
                label = node.hasProperty("label") ? node.getProperty("label").getString() : node.getName();
                icon = "uiIcon16x16Template" + label.replaceAll(" ", "");
                icon = (String)icon + " uiIconFile";
                if (this.filter.equals(DOCUMENTS_TEMPLATE_TYPE)) {
                    if (!documentNodeTypes.contains(node.getName())) continue;
                    templateData.add(new TemplateData(node.getName(), label, (String)icon));
                    continue;
                }
                if (this.filter.equals(ACTIONS_TEMPLATE_TYPE)) {
                    if (!ntManager.getNodeType(node.getName()).isNodeType("exo:action")) continue;
                    templateData.add(new TemplateData(node.getName(), label, (String)icon));
                    continue;
                }
                if (ntManager.getNodeType(node.getName()).isNodeType("exo:action") || documentNodeTypes.contains(node.getName())) continue;
                templateData.add(new TemplateData(node.getName(), label, (String)icon));
            }
            Collections.sort(templateData, new TemplateComparator());
        }
        ListAccessImpl dataList = new ListAccessImpl(TemplateData.class, templateData);
        LazyPageList pageList = new LazyPageList((ListAccess)dataList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setTotalItems(templateData.size());
        this.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public static class TemplateData {
        private String name;
        private String label;
        private String icon;

        public TemplateData(String dataName, String dataLabel, String dataIcon) {
            this.name = dataName;
            this.label = dataLabel;
            this.icon = dataIcon;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIcon() {
            return this.icon;
        }
    }

    public static class AddNewActionListener
    extends EventListener<UITemplateList> {
        public void execute(Event<UITemplateList> event) throws Exception {
            UITemplatesManager uiTemplatesManager = (UITemplatesManager)((UITemplateList)((Object)event.getSource())).getAncestorOfType(UITemplatesManager.class);
            UITemplateContainer uiTemplateContainer = (UITemplateContainer)uiTemplatesManager.getChildById(uiTemplatesManager.getSelectedTabId());
            UITemplateList uiList = (UITemplateList)uiTemplateContainer.getChild(UITemplateList.class);
            UITemplateForm uiTemplateForm = (UITemplateForm)uiTemplateContainer.createUIComponent(UITemplateForm.class, null, null);
            uiTemplateForm.setFilter(uiList.getTemplateFilter());
            uiTemplateForm.refresh();
            uiTemplatesManager.initPopup((UIComponent)uiTemplateForm);
            UIPopupWindow uiPopup = (UIPopupWindow)uiTemplatesManager.getChildById("TemplateContainerPopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UITemplateList> {
        public void execute(Event<UITemplateList> event) throws Exception {
            UITemplatesManager uiTemplatesManager = (UITemplatesManager)((UITemplateList)((Object)event.getSource())).getAncestorOfType(UITemplatesManager.class);
            UITemplateContainer uiTemplateContainer = (UITemplateContainer)uiTemplatesManager.getChildById(uiTemplatesManager.getSelectedTabId());
            UITemplateList uiTemplateList = (UITemplateList)uiTemplateContainer.getChild(UITemplateList.class);
            if (uiTemplatesManager.isEditingTemplate()) {
                UIApplication uiApp = (UIApplication)((UITemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UITemplateList.msg.editing-template", null, 1));
                return;
            }
            String nodeType = event.getRequestContext().getRequestParameter("objectId");
            TemplateService templateService = (TemplateService)uiTemplateList.getApplicationComponent(TemplateService.class);
            try {
                DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", true);
                templateService.removeManagedNodeType(nodeType);
            }
            catch (PathNotFoundException ex) {
                UIApplication uiApp = (UIApplication)((UITemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UITemplateList.msg.template-not-exist", null, 1));
                return;
            }
            uiTemplateList.refresh(uiTemplateList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplatesManager);
        }
    }

    public static class EditActionListener
    extends EventListener<UITemplateList> {
        public void execute(Event<UITemplateList> event) throws Exception {
            UITemplateList nodeTemplateList = (UITemplateList)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)nodeTemplateList.getAncestorOfType(UITemplatesManager.class);
            UITemplateContainer uiTemplateContainer = (UITemplateContainer)uiManager.getChildById(uiManager.getSelectedTabId());
            String nodeType = event.getRequestContext().getRequestParameter("objectId");
            UIViewTemplate uiViewTemplate = (UIViewTemplate)uiTemplateContainer.createUIComponent(UIViewTemplate.class, null, "UIViewTemplate_" + uiManager.getSelectedTabId());
            ((UITemplateEditForm)uiViewTemplate.getChild(UITemplateEditForm.class)).update(nodeType);
            uiViewTemplate.setNodeTypeName(nodeType);
            UIDialogTab uiDialogTab = (UIDialogTab)uiViewTemplate.findFirstComponentOfType(UIDialogTab.class);
            uiDialogTab.updateGrid(nodeType);
            UITemplateContent uiDialogTabForm = (UITemplateContent)uiViewTemplate.findComponentById("DialogForm");
            uiDialogTabForm.setNodeTypeName(nodeType);
            uiDialogTabForm.update(null);
            UIViewTab uiViewTab = (UIViewTab)uiViewTemplate.findFirstComponentOfType(UIViewTab.class);
            uiViewTab.updateGrid(nodeType);
            UITemplateContent uiViewTabForm = (UITemplateContent)uiViewTemplate.findComponentById("ViewForm");
            uiViewTabForm.setNodeTypeName(nodeType);
            uiViewTabForm.update(null);
            UISkinTab uiSkinTab = (UISkinTab)uiViewTemplate.findFirstComponentOfType(UISkinTab.class);
            uiSkinTab.updateGrid(nodeType);
            UITemplateContent uiSkinTabForm = (UITemplateContent)uiViewTemplate.findComponentById("SkinForm");
            uiSkinTabForm.setNodeTypeName(nodeType);
            uiSkinTabForm.update(null);
            uiManager.initPopup((UIComponent)uiViewTemplate);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChildById("TemplateContainerPopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class TemplateComparator
    implements Comparator<TemplateData> {
        @Override
        public int compare(TemplateData t1, TemplateData t2) throws ClassCastException {
            String name1 = t1.getName();
            String name2 = t2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

