/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.search.Sorting;

public class ProfileFilter
implements Cloneable {
    private String name = "";
    private String position = "";
    private String company = "";
    private String skills = "";
    private boolean searchEmail;
    private String all = "";
    private List<Identity> excludedIdentityList = new ArrayList<Identity>();
    private List<String> onlineRemoteIds = new ArrayList<String>();
    private Identity viewerIdentity;
    private char firstCharacterOfName = '\u0000';
    private String userType;
    private String enrollmentStatus;
    private Boolean isConnected;
    private List<String> remoteIds = null;
    private Sorting sorting;
    private String firstCharFieldName = null;
    private boolean isEnabled = true;

    public void setSearchEmail(boolean searchEmail) {
        this.searchEmail = searchEmail;
    }

    public boolean isSearchEmail() {
        return this.searchEmail;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getSkills() {
        return this.skills;
    }

    public void setSkills(String skills) {
        this.skills = skills;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setExcludedIdentityList(List<Identity> excludedIdentityList) {
        this.excludedIdentityList = excludedIdentityList;
    }

    public List<Identity> getExcludedIdentityList() {
        return this.excludedIdentityList;
    }

    public void setOnlineRemoteIds(List<String> onlineRemoteIds) {
        this.onlineRemoteIds = onlineRemoteIds;
    }

    public List<String> getOnlineRemoteIds() {
        return this.onlineRemoteIds;
    }

    public char getFirstCharacterOfName() {
        return this.firstCharacterOfName;
    }

    public void setFirstCharacterOfName(char firstCharacterOfName) {
        this.firstCharacterOfName = firstCharacterOfName;
    }

    public String getAll() {
        return this.all;
    }

    public void setAll(String all) {
        this.all = Utils.processUnifiedSearchCondition(all);
    }

    public boolean isSortingEmpty() {
        return this.sorting == null;
    }

    public Sorting getSorting() {
        if (this.sorting == null) {
            return new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC);
        }
        return this.sorting;
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getEnrollmentStatus() {
        return this.enrollmentStatus;
    }

    public void setEnrollmentStatus(String enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public Boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(Boolean isConnected) {
        this.isConnected = isConnected;
    }

    public Identity getViewerIdentity() {
        return this.viewerIdentity;
    }

    public void setViewerIdentity(Identity currentIdentity) {
        if (currentIdentity == null && this.viewerIdentity != null && this.excludedIdentityList != null) {
            this.excludedIdentityList.remove(this.viewerIdentity);
        }
        this.viewerIdentity = currentIdentity;
        if (currentIdentity == null) {
            return;
        }
        if (this.excludedIdentityList == null) {
            this.excludedIdentityList = new ArrayList<Identity>();
        }
        if (!this.excludedIdentityList.contains(currentIdentity)) {
            this.excludedIdentityList.add(this.viewerIdentity);
        }
    }

    public void setRemoteIds(List<String> remoteIds) {
        this.remoteIds = remoteIds;
    }

    public List<String> getRemoteIds() {
        return this.remoteIds;
    }

    public String getFirstCharFieldName() {
        return this.firstCharFieldName;
    }

    public void setFirstCharFieldName(String firstCharField) {
        this.firstCharFieldName = firstCharField;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((String)this.all) && StringUtils.isBlank((String)this.name) && StringUtils.isBlank((String)this.company) && StringUtils.isBlank((String)this.position) && StringUtils.isBlank((String)this.skills) && (this.remoteIds == null || this.remoteIds.isEmpty()) && (this.excludedIdentityList == null || this.excludedIdentityList.isEmpty() || this.excludedIdentityList.size() == 1 && this.viewerIdentity != null && this.excludedIdentityList.contains(this.viewerIdentity));
    }

    public ProfileFilter clone() throws CloneNotSupportedException {
        return (ProfileFilter)super.clone();
    }
}

