/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.coverage.ColorModelPatch;
import org.apache.sis.internal.coverage.MultiBandsIndexColorModel;
import org.apache.sis.internal.coverage.ScaledColorSpace;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.collection.WeakValueHashMap;

public final class ColorModelFactory {
    public static final Function<Category, Color[]> GRAYSCALE = category -> {
        Color[] colorArray;
        if (category.isQuantitative()) {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = Color.BLACK;
            colorArray = colorArray2;
            colorArray2[1] = Color.WHITE;
        } else {
            colorArray = null;
        }
        return colorArray;
    };
    private static final WeakHashSet<ColorModelPatch> CACHE = new WeakHashSet(ColorModelPatch.class);
    private static final Map<ColorModelFactory, ColorModel> PIECEWISES = new WeakValueHashMap(ColorModelFactory.class);
    private static final Comparator<Map.Entry<NumberRange<?>, Color[]>> RANGE_COMPARATOR = (entry, entry2) -> Double.compare(((NumberRange)entry.getKey()).getMinDouble(true), ((NumberRange)entry2.getKey()).getMinDouble(true));
    private final double minimum;
    private final double maximum;
    private final int[] pieceStarts;
    private final int[][] ARGB;
    private final int visibleBand;
    private final int numBands;
    private final int type;

    private ColorModelFactory(Map<? extends NumberRange<?>, ? extends Color[]> map, int n, int n2, int n3) {
        this.visibleBand = n;
        this.numBands = n2;
        this.type = n3;
        Map.Entry[] entryArray = map.entrySet().toArray(new Map.Entry[map.size()]);
        Arrays.sort(entryArray, RANGE_COMPARATOR);
        int n4 = 0;
        int[] nArray = new int[entryArray.length + 1];
        Object object = new int[entryArray.length][];
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : entryArray) {
            int n5;
            int n6;
            int n7;
            NumberRange numberRange = (NumberRange)entry.getKey();
            double d3 = numberRange.getMinDouble(true);
            double d4 = numberRange.getMaxDouble(false);
            if (d3 < d) {
                d = d3;
            }
            if (d4 > d2) {
                d2 = d4;
            }
            if ((n7 = Math.round((float)d3)) >= (n6 = Math.round((float)d4))) continue;
            if (n7 < 0 || n6 > 65536) {
                nArray = ArraysExt.EMPTY_INT;
                object = null;
                n4 = 0;
                continue;
            }
            if (object == null) continue;
            if (n4 != 0 && (n5 = nArray[n4]) != n7 && n5 <= n7) {
                object = (int[][])Arrays.copyOf(object, ((int[][])object).length + 1);
                nArray = Arrays.copyOf(nArray, nArray.length + 1);
                object[n4++] = ArraysExt.EMPTY_INT;
            }
            object[n4] = ColorModelFactory.toARGB((Color[])entry.getValue());
            nArray[n4] = n7;
            nArray[++n4] = n6;
        }
        if (d >= d2) {
            d = 0.0;
            d2 = 1.0;
        }
        if (nArray.length != 0) {
            nArray = ArraysExt.resize((int[])nArray, (int)(n4 + 1));
        }
        this.minimum = d;
        this.maximum = d2;
        this.pieceStarts = nArray;
        this.ARGB = object;
    }

    private ColorModel createColorModel() {
        int[] nArray;
        if (this.type != 0 && this.type != 1) {
            ColorSpace colorSpace = ColorModelFactory.createColorSpace(this.numBands, this.visibleBand, this.minimum, this.maximum);
            return ColorModelFactory.unique(new ComponentColorModel(colorSpace, false, false, 1, this.type));
        }
        int n = this.pieceStarts.length - 1;
        if (this.numBands == 1 && n <= 0) {
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            int[] nArray2 = new int[]{DataBuffer.getDataTypeSize(this.type)};
            return ColorModelFactory.unique(new ComponentColorModel(colorSpace, nArray2, false, true, 1, this.type));
        }
        int n2 = -1;
        if (n <= 0) {
            nArray = ArraysExt.range((int)0, (int)256);
        } else {
            nArray = new int[this.pieceStarts[n]];
            for (int i = 0; i < n; ++i) {
                int[] nArray3 = this.ARGB[i];
                int n3 = this.pieceStarts[i];
                int n4 = this.pieceStarts[i + 1];
                if (n2 < 0 && nArray3.length == 0) {
                    n2 = n3;
                }
                ColorModelFactory.expand(nArray3, nArray, n3, n4);
            }
        }
        return ColorModelFactory.createIndexColorModel(nArray, this.numBands, this.visibleBand, n2);
    }

    public int hashCode() {
        int n = this.pieceStarts.length - 1;
        int n2 = 962745549 + (this.numBands * 31 + this.visibleBand) * 31 + n;
        for (int i = 0; i < n; ++i) {
            n2 += Arrays.hashCode(this.ARGB[i]);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ColorModelFactory) {
            ColorModelFactory colorModelFactory = (ColorModelFactory)object;
            return this.type == colorModelFactory.type && this.numBands == colorModelFactory.numBands && this.visibleBand == colorModelFactory.visibleBand && this.minimum == colorModelFactory.minimum && this.maximum == colorModelFactory.maximum && Arrays.equals(this.pieceStarts, colorModelFactory.pieceStarts) && Arrays.deepEquals((Object[])this.ARGB, (Object[])colorModelFactory.ARGB);
        }
        return false;
    }

    public static ColorModel createColorModel(SampleDimension[] sampleDimensionArray, int n, int n2, Function<Category, Color[]> function) {
        ArgumentChecks.ensureNonNull((String)"bands", (Object)sampleDimensionArray);
        ArgumentChecks.ensureNonNull((String)"colors", function);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Category category : sampleDimensionArray[n].getCategories()) {
            linkedHashMap.put(category.getSampleRange(), function.apply(category));
        }
        return ColorModelFactory.createColorModel(linkedHashMap, n, sampleDimensionArray.length, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorModel createColorModel(Map<? extends NumberRange<?>, ? extends Color[]> map, int n, int n2, int n3) {
        ArgumentChecks.ensureNonNull((String)"categories", map);
        ArgumentChecks.ensureBetween((String)"visibleBand", (int)0, (int)(n2 - 1), (int)n);
        ColorModelFactory colorModelFactory = new ColorModelFactory(map, n, n2, n3);
        Map<ColorModelFactory, ColorModel> map2 = PIECEWISES;
        synchronized (map2) {
            ColorModel colorModel = PIECEWISES.get(colorModelFactory);
            if (colorModel == null) {
                colorModel = colorModelFactory.createColorModel();
                PIECEWISES.put(colorModelFactory, colorModel);
            }
            return colorModel;
        }
    }

    public static IndexColorModel createIndexColorModel(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        int n5 = ColorModelFactory.getBitCount(n4);
        int n6 = ColorModelFactory.getTransferType(n4);
        IndexColorModel indexColorModel = n == 1 ? new IndexColorModel(n5, n4, nArray, 0, true, n3, n6) : new MultiBandsIndexColorModel(n5, n4, nArray, 0, true, n3, n6, n, n2);
        return ColorModelFactory.unique(indexColorModel);
    }

    public static ColorSpace createColorSpace(int n, int n2, double d, double d2) {
        if (n == 1 && d == 0.0 && d2 == 1.0) {
            return ColorSpace.getInstance(1003);
        }
        return new ScaledColorSpace(n, n2, d, d2);
    }

    public static <T extends ColorModel> T unique(T t) {
        ColorModelPatch colorModelPatch = new ColorModelPatch(t);
        colorModelPatch = (ColorModelPatch)CACHE.unique(colorModelPatch);
        return colorModelPatch.cm;
    }

    private static int getTransferType(int n) {
        return n <= 256 ? 0 : 1;
    }

    public static int getBitCount(int n) {
        int n2 = 32 - Integer.numberOfLeadingZeros(n - 1);
        assert (1 << n2 >= n) : n;
        assert (1 << n2 - 1 < n) : n;
        return Math.max(1, n2);
    }

    private static int[] toARGB(Color[] colorArray) {
        if (colorArray != null) {
            int n = 0;
            int[] nArray = new int[colorArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                Color color = colorArray[i];
                if (color == null) continue;
                int n2 = color.getRGB();
                n |= n2;
                nArray[i] = n2;
            }
            if ((n & 0xFF000000) != 0) {
                return nArray;
            }
        }
        return ArraysExt.EMPTY_INT;
    }

    public static void expand(int[] nArray, int[] nArray2, int n, int n2) {
        switch (nArray.length) {
            case 1: {
                Arrays.fill(nArray2, n, n2, nArray[0]);
            }
            case 0: {
                return;
            }
        }
        switch (n2 - n) {
            case 1: {
                nArray2[n] = nArray[0];
            }
            case 0: {
                return;
            }
        }
        double d = (double)(nArray.length - 1) / (double)(n2 - n - 1);
        int n3 = nArray.length - 2;
        float f = 0.0f;
        int n4 = 0;
        int n5 = n;
        while (true) {
            int n6 = nArray[n4];
            int n7 = nArray[n4 + 1];
            int n8 = n6 >>> 24 & 0xFF;
            int n9 = (n7 >>> 24 & 0xFF) - n8;
            int n10 = n6 >>> 16 & 0xFF;
            int n11 = (n7 >>> 16 & 0xFF) - n10;
            int n12 = n6 >>> 8 & 0xFF;
            int n13 = (n7 >>> 8 & 0xFF) - n12;
            int n14 = n6 & 0xFF;
            int n15 = (n7 & 0xFF) - n14;
            int n16 = n4;
            do {
                float f2 = f - (float)n4;
                nArray2[n5] = ColorModelFactory.roundByte((float)n8 + f2 * (float)n9) << 24 | ColorModelFactory.roundByte((float)n10 + f2 * (float)n11) << 16 | ColorModelFactory.roundByte((float)n12 + f2 * (float)n13) << 8 | ColorModelFactory.roundByte((float)n14 + f2 * (float)n15);
                if (++n5 != n2) continue;
                return;
            } while ((n4 = Math.min(n3, (int)((f = (float)((double)(n5 - n) * d)) + Math.ulp(f)))) == n16);
        }
    }

    private static int roundByte(float f) {
        return Math.min(Math.max(Math.round(f), 0), 255);
    }
}

