/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.plugin;

import org.exoplatform.commons.api.settings.FeaturePlugin;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class ComposerAttachmentFeaturePlugin
extends FeaturePlugin {
    private static final String COMPOSER_ATTACH_FILE_FEATURE_NAME = "activityComposerAttachFile";
    public static final Scope APP_SCOPE = Scope.APPLICATION.id("changesReminder");
    private final SettingService settingService;
    private final IdentityManager identityManager;

    public ComposerAttachmentFeaturePlugin(SettingService settingService, IdentityManager identityManager) {
        this.settingService = settingService;
        this.identityManager = identityManager;
    }

    public String getName() {
        return COMPOSER_ATTACH_FILE_FEATURE_NAME;
    }

    public boolean isFeatureActiveForUser(String featureName, String username) {
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", username);
        Profile userProfile = userIdentity.getProfile();
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), "activityComposerAttachFileCreationDate");
        SettingValue userSettingValue = this.settingService.get(Context.USER.id(userIdentity.getRemoteId()), APP_SCOPE, featureName);
        return userProfile.getCreatedTime() <= Long.parseLong(settingValue.getValue().toString()) && userSettingValue == null;
    }

    public void init() {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), "activityComposerAttachFileCreationDate");
        if (settingValue == null) {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), "activityComposerAttachFileCreationDate", SettingValue.create((Long)System.currentTimeMillis()));
        }
    }
}

