/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class SQLUtilities
extends Static {
    private SQLUtilities() {
    }

    public static String getSimplifiedURL(DatabaseMetaData databaseMetaData) throws SQLException {
        int n;
        String string = databaseMetaData.getURL();
        int n2 = string.indexOf(63);
        if (n2 < 0) {
            n2 = string.length();
        }
        if ((n = string.indexOf(59)) < 0) {
            n = string.length();
        }
        return string.substring(0, Math.min(n2, n));
    }

    public static Boolean parseBoolean(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (string.length()) {
            case 0: {
                return null;
            }
            case 1: {
                switch (string.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                    case '1': 
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                }
                break;
            }
            default: {
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
                    return Boolean.TRUE;
                }
                if (!string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no")) break;
                return Boolean.FALSE;
            }
        }
        throw new SQLDataException(Errors.format((short)8, (Object)string, Boolean.class));
    }

    public static String escape(String string, String string2) {
        if (string != null) {
            StringBuilder stringBuilder = null;
            int n = string.length();
            while (--n >= 0) {
                char c = string.charAt(n);
                if (c != '_' && c != '%') continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                }
                stringBuilder.insert(n, string2);
            }
            if (stringBuilder != null) {
                return stringBuilder.toString();
            }
        }
        return string;
    }

    public static void toLikePattern(String string, int n, int n2, boolean bl, boolean bl2, StringBuilder stringBuilder) {
        int n3 = stringBuilder.length();
        while (n < n2) {
            int n4 = string.codePointAt(n);
            if (Character.isLetterOrDigit(n4)) {
                if (n4 < 128) {
                    stringBuilder.appendCodePoint(bl2 ? Character.toLowerCase(n4) : n4);
                } else {
                    SQLUtilities.appendIfNotRedundant(stringBuilder, '_');
                }
            } else {
                int n5 = stringBuilder.length();
                if (n5 == n3) {
                    stringBuilder.appendCodePoint(n4 != 37 ? n4 : 95);
                } else if (stringBuilder.charAt(n5 - 1) != '%') {
                    stringBuilder.append('%');
                }
            }
            n += Character.charCount(n4);
        }
        if (bl) {
            SQLUtilities.appendIfNotRedundant(stringBuilder, '%');
        }
        n = n3;
        while ((n = stringBuilder.indexOf("_%", n)) >= 0) {
            stringBuilder.deleteCharAt(n);
        }
    }

    private static void appendIfNotRedundant(StringBuilder stringBuilder, char c) {
        int n = stringBuilder.length();
        if (n == 0 || stringBuilder.charAt(n - 1) != '%') {
            stringBuilder.append(c);
        }
    }

    public static boolean filterFalsePositive(String string, String string2) {
        return CharSequences.equalsFiltered((CharSequence)string, (CharSequence)string2, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)false);
    }
}

