/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import javax.servlet.ServletConfig;
import org.cometd.client.BayeuxClient;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.cometd.oort.OortConfigServlet;

public class OortStaticConfigServlet
extends OortConfigServlet {
    public static final String OORT_CLOUD_PARAM = "oort.cloud";

    @Override
    protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
        String cloud = config.getInitParameter(OORT_CLOUD_PARAM);
        if (cloud != null && cloud.length() > 0) {
            String[] urls;
            for (String comet : urls = cloud.split(",")) {
                if ((comet = comet.trim()).length() <= 0) continue;
                OortComet oortComet = oort.observeComet(comet);
                if (oortComet == null) {
                    throw new IllegalArgumentException("Invalid value for oort.cloud");
                }
                oortComet.waitFor(1000L, BayeuxClient.State.CONNECTED, new BayeuxClient.State[]{BayeuxClient.State.DISCONNECTED});
            }
        }
    }
}

