/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.unlock;

import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.unlock.UIUnLockManager;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/unlock/UILockList.gtmpl", events={@EventConfig(listeners={DeleteLockActionListener.class})})
public class UILockList
extends UIPagingGridDecorator {
    public static final String[] ACTIONS = new String[0];
    public static final String ST_EDIT = "EditUnLockForm";

    public UILockList() throws Exception {
        this.getUIPageIterator().setId("LockListIterator");
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(int currentPage) throws Exception {
        ListAccessImpl groupsAndUsersForLockList = new ListAccessImpl(String.class, this.getAllGroupsOrUsersForLock());
        LazyPageList pageList = new LazyPageList((ListAccess)groupsAndUsersForLockList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public List getGroupsOrUsersForLock() throws Exception {
        return this.getUIPageIterator().getCurrentPageData();
    }

    public List<String> getAllGroupsOrUsersForLock() throws Exception {
        LockService lockService = (LockService)this.getApplicationComponent(LockService.class);
        return lockService.getAllGroupsOrUsersForLock();
    }

    public static class DeleteLockActionListener
    extends EventListener<UILockList> {
        public void execute(Event<UILockList> event) throws Exception {
            UIUnLockManager uiUnLockManager = (UIUnLockManager)((UILockList)((Object)event.getSource())).getParent();
            String settingLock = event.getRequestContext().getRequestParameter("objectId");
            LockService lockService = (LockService)uiUnLockManager.getApplicationComponent(LockService.class);
            lockService.removeGroupsOrUsersForLock(settingLock);
            UILockList uiLockList = (UILockList)uiUnLockManager.getChild(UILockList.class);
            uiLockList.refresh(uiLockList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
        }
    }
}

