/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.features;

import org.exoplatform.container.component.BaseComponentPlugin;

public abstract class FeatureSpec<T>
extends BaseComponentPlugin {
    public abstract boolean isSatisfiedBy(T var1);

    public final FeatureSpec<T> and(FeatureSpec<T> other) {
        return new AndSpec<T>(this, other);
    }

    public final FeatureSpec<T> or(FeatureSpec<T> other) {
        return new OrSpec<T>(this, other);
    }

    public final FeatureSpec<T> not() {
        return new NotSpec(this);
    }

    class NotSpec<C>
    extends FeatureSpec<C> {
        final FeatureSpec<C> one;

        NotSpec(FeatureSpec<C> one) {
            this.one = one;
        }

        @Override
        public boolean isSatisfiedBy(C target) {
            return !this.one.isSatisfiedBy(target);
        }
    }

    static class OrSpec<C>
    extends CompositeSpec<C> {
        OrSpec(FeatureSpec<C> one, FeatureSpec<C> other) {
            super(one, other);
        }

        @Override
        public boolean isSatisfiedBy(C target) {
            return this.one.isSatisfiedBy(target) || this.other.isSatisfiedBy(target);
        }
    }

    static class AndSpec<C>
    extends CompositeSpec<C> {
        AndSpec(FeatureSpec<C> one, FeatureSpec<C> other) {
            super(one, other);
        }

        @Override
        public boolean isSatisfiedBy(C target) {
            return this.one.isSatisfiedBy(target) && this.other.isSatisfiedBy(target);
        }
    }

    static abstract class CompositeSpec<C>
    extends FeatureSpec<C> {
        final FeatureSpec<C> one;
        final FeatureSpec<C> other;

        public CompositeSpec(FeatureSpec<C> one, FeatureSpec<C> other) {
            this.one = one;
            this.other = other;
        }
    }
}

