/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.handler;

import java.io.PrintWriter;
import java.io.Serializable;
import javax.jcr.Node;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.ecm.utils.MessageDigester;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;

public class SiteJavascriptHandler
extends WebRequestHandler {
    private static final Log LOG = ExoLogger.getLogger((String)SiteJavascriptHandler.class.getName());
    private ExoCache<String, Object> jsCache_;
    private String siteName_;
    private LivePortalManagerService livePortalManagerService_;
    public static final String CACHE_REGION = "ecms.site.javascript.cache";

    public String getHandlerName() {
        return "javascript";
    }

    public synchronized boolean execute(ControllerContext context) throws Exception {
        if (this.jsCache_ == null) {
            this.jsCache_ = WCMCoreUtils.getService(CacheService.class).getCacheInstance(CACHE_REGION);
        }
        this.siteName_ = context.getParameter(QualifiedName.create((String)"gtn", (String)"sitename"));
        String key = MessageDigester.getHash(this.siteName_);
        String jsData = (String)this.jsCache_.get((Serializable)((Object)key));
        if (jsData == null) {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            this.livePortalManagerService_ = WCMCoreUtils.getService(LivePortalManagerService.class);
            Node portalNode = null;
            try {
                portalNode = "shared".equals(this.siteName_) ? this.livePortalManagerService_.getLiveSharedPortal(sessionProvider) : this.livePortalManagerService_.getLivePortal(sessionProvider, this.siteName_);
            }
            catch (Exception e) {
                LOG.warn("Can't find JCR portal node for site '{}'", new Object[]{this.siteName_});
            }
            if (portalNode == null) {
                return false;
            }
            jsData = WCMCoreUtils.getSiteGlobalActiveJs(portalNode, sessionProvider);
            this.jsCache_.put((Serializable)((Object)key), (Object)jsData);
        }
        HttpServletResponse res = context.getResponse();
        res.setContentType("text/javascript");
        PrintWriter out = res.getWriter();
        out.println(jsData);
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

