/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.exoplatform.web.controller.regexp.GroupType;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.RERenderer;
import org.exoplatform.web.controller.regexp.REVisitor;

public class ValueResolverFactory
extends REVisitor<RuntimeException> {
    private List<Alternative> alternatives = new ArrayList<Alternative>();
    private Alternative current = null;
    private Solver solver;

    public List<Alternative> foo(RENode root) {
        this.alternatives.clear();
        root.accept(this);
        return this.alternatives;
    }

    @Override
    protected void visit(RENode.Disjunction disjunction) throws RuntimeException {
        if (this.current != null) {
            RENode.Alternative alternative = disjunction.getAlternative();
            if (alternative != null) {
                alternative.accept(this);
            }
        } else {
            RENode.Disjunction next;
            RENode.Alternative alternative = disjunction.getAlternative();
            if (alternative != null) {
                this.current = new Alternative();
                alternative.accept(this);
                this.current.suffix = this.current.buffer.toString();
                this.current.buffer.setLength(0);
                this.alternatives.add(this.current);
                this.current = null;
            }
            if ((next = disjunction.getNext()) != null) {
                next.accept(this);
            }
        }
    }

    @Override
    protected void visit(RENode.Group expr) throws RuntimeException {
        if (expr.getType() == GroupType.CAPTURING_GROUP) {
            RERenderer renderer;
            try {
                renderer = new RERenderer(this.current.resolvingExpression);
                expr.accept(renderer);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            try {
                renderer = new RERenderer(this.current.valueMatcher);
                expr.accept(renderer);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.current.prefix = this.current.buffer.toString();
            this.current.buffer.setLength(0);
        } else {
            super.visit(expr);
        }
    }

    @Override
    protected void visit(RENode.Alternative alternative) throws RuntimeException {
        alternative.getExpr().accept(this);
        RENode.Alternative next = alternative.getNext();
        if (next != null) {
            next.accept(this);
        }
    }

    @Override
    protected void visit(RENode.Char expr) throws RuntimeException {
        for (int i = expr.getMin(); i > 0; --i) {
            this.current.resolvingExpression.append(expr.getValue());
            this.current.buffer.append(expr.getValue());
        }
    }

    @Override
    protected void visit(RENode.Any expr) throws RuntimeException {
        for (int i = expr.getMin(); i > 0; --i) {
            this.current.resolvingExpression.append('a');
            this.current.buffer.append('a');
        }
    }

    @Override
    protected void visit(RENode.CharacterClass expr) throws RuntimeException {
        expr.getExpr().accept(this);
        for (int i = expr.getMin(); i > 0; --i) {
            if (!this.solver.hasNext()) {
                throw new UnsupportedOperationException("wtf?");
            }
            char c = ((Character)this.solver.next()).charValue();
            this.current.resolvingExpression.append(c);
            this.current.buffer.append(c);
            this.solver.reset();
        }
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Or expr) throws RuntimeException {
        expr.getLeft().accept(this);
        Solver left = this.solver;
        expr.getRight().accept(this);
        Solver right = this.solver;
        this.solver = new Solver.Or(left, right);
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Range expr) throws RuntimeException {
        RENode.CharacterClassExpr.Char from = expr.getFrom();
        RENode.CharacterClassExpr.Char to = expr.getTo();
        this.solver = new Solver.Range(from.getValue(), to.getValue());
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Char expr) throws RuntimeException {
        this.solver = new Solver.Char(expr.getValue());
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.And expr) throws RuntimeException {
        expr.getLeft().accept(this);
        Solver left = this.solver;
        expr.getRight().accept(this);
        Solver right = this.solver;
        this.solver = new Solver.And(left, right);
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Not expr) throws RuntimeException {
        RENode.CharacterClassExpr negated = expr.getNegated();
        if (negated != null) {
            this.negate(negated);
        }
    }

    private void negate(RENode.CharacterClassExpr negated) throws RuntimeException {
        if (negated instanceof RENode.CharacterClassExpr.Not) {
            RENode.CharacterClassExpr nested = ((RENode.CharacterClassExpr.Not)negated).getNegated();
            if (nested != null) {
                nested.accept(this);
            }
        } else if (negated instanceof RENode.CharacterClassExpr.Or) {
            RENode.CharacterClassExpr.Or or = (RENode.CharacterClassExpr.Or)negated;
            this.negate(or.getLeft());
            Solver left = this.solver;
            this.negate(or.getRight());
            Solver right = this.solver;
            this.solver = new Solver.And(left, right);
        } else if (negated instanceof RENode.CharacterClassExpr.And) {
            RENode.CharacterClassExpr.And or = (RENode.CharacterClassExpr.And)negated;
            this.negate(or.getLeft());
            Solver left = this.solver;
            this.negate(or.getRight());
            Solver right = this.solver;
            this.solver = new Solver.Or(left, right);
        } else {
            char from;
            char to;
            if (negated instanceof RENode.CharacterClassExpr.Char) {
                from = to = ((RENode.CharacterClassExpr.Char)negated).getValue();
            } else if (negated instanceof RENode.CharacterClassExpr.Range) {
                RENode.CharacterClassExpr.Range range = (RENode.CharacterClassExpr.Range)negated;
                from = range.getFrom().getValue();
                to = range.getTo().getValue();
            } else {
                throw new UnsupportedOperationException();
            }
            Solver.Range left = null;
            from = (char)(from - '\u0001');
            Character c = ValueResolverFactory.prevValid(from);
            if (c != null) {
                left = new Solver.Range(' ', c.charValue());
            }
            Solver.Range right = null;
            c = ValueResolverFactory.nextValid(to = (char)(to + '\u0001'));
            if (c != null) {
                right = new Solver.Range(c.charValue(), '\uffff');
            }
            if (left == null) {
                if (right != null) {
                    this.solver = right;
                }
            } else {
                this.solver = right == null ? left : new Solver.Or(left, right);
            }
        }
    }

    private static Character nextValid(char from) {
        while (Character.isISOControl(from)) {
            if (from == '\uffff') {
                return null;
            }
            from = (char)(from + '\u0001');
        }
        return Character.valueOf(from);
    }

    private static Character prevValid(char from) {
        while (Character.isISOControl(from)) {
            if (from == '\u0000') {
                return null;
            }
            from = (char)(from - '\u0001');
        }
        return Character.valueOf(from);
    }

    private static abstract class Solver
    implements Iterator<Character> {
        private Solver() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract void reset();

        private static class Char
        extends Solver {
            private final char value;
            private boolean done;

            private Char(char value) {
                this.value = value;
                this.done = false;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public Character next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return Character.valueOf(this.value);
            }

            @Override
            protected void reset() {
                this.done = false;
            }
        }

        private static class Range
        extends Solver {
            private char from;
            private char current;
            private char to;

            private Range(char from, char to) {
                this.from = from;
                this.current = from;
                this.to = to;
            }

            @Override
            public boolean hasNext() {
                return this.current < this.to;
            }

            @Override
            public Character next() {
                if (this.current >= this.to) {
                    throw new NoSuchElementException();
                }
                char c = this.current;
                this.current = (char)(c + '\u0001');
                return Character.valueOf(c);
            }

            @Override
            protected void reset() {
                this.current = this.from;
            }
        }

        private static class Or
        extends Solver {
            private final Solver left;
            private final Solver right;

            private Or(Solver left, Solver right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean hasNext() {
                return this.left.hasNext() || this.right.hasNext();
            }

            @Override
            public Character next() {
                if (this.left.hasNext()) {
                    return (Character)this.left.next();
                }
                if (this.right.hasNext()) {
                    return (Character)this.right.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            protected void reset() {
                this.left.reset();
                this.right.reset();
            }
        }

        private static class And
        extends Solver {
            private final Solver left;
            private final Solver right;
            private Character leftChar;
            private Character next;

            private And(Solver left, Solver right) {
                this.left = left;
                this.right = right;
                this.next = null;
                this.leftChar = null;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.leftChar == null) {
                        if (!this.left.hasNext()) break;
                        this.leftChar = (Character)this.left.next();
                    }
                    if (this.right.hasNext()) {
                        Character c = (Character)this.right.next();
                        if (c != this.leftChar) continue;
                        this.next = c;
                        continue;
                    }
                    this.right.reset();
                    this.leftChar = null;
                }
                return this.next != null;
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Character tmp = this.next;
                this.next = null;
                return tmp;
            }

            @Override
            protected void reset() {
                this.left.reset();
                this.right.reset();
            }
        }
    }

    static class Alternative {
        private StringBuilder resolvingExpression = new StringBuilder();
        private String prefix;
        private String suffix;
        private StringBuilder buffer = new StringBuilder();
        private StringBuilder valueMatcher = new StringBuilder();

        Alternative() {
        }

        public StringBuilder getResolvingExpression() {
            return this.resolvingExpression;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public StringBuilder getValueMatcher() {
            return this.valueMatcher;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.resolvingExpression + "]";
        }
    }
}

